/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.exception;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

public class DatabaseException
extends Exception {
    private static final long serialVersionUID = -6234485044648476711L;
    private ArrayList<Resource> resources;
    private ArrayList<String> names;
    private ArrayList<Integer> indices;

    public DatabaseException() {
    }

    public DatabaseException(String message, Throwable cause) {
        super(message, cause);
    }

    public DatabaseException(String message, Throwable cause, Resource ... rs) {
        super(message, cause);
        this.resources = new ArrayList();
        Resource[] resourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            this.resources.add(r);
            ++n2;
        }
    }

    public DatabaseException(Throwable cause, Resource ... rs) {
        super(cause);
        this.resources = new ArrayList();
        Resource[] resourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            this.resources.add(r);
            ++n2;
        }
    }

    public DatabaseException(String message, Resource ... rs) {
        super(message);
        this.resources = new ArrayList();
        Resource[] resourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            this.resources.add(r);
            ++n2;
        }
    }

    public DatabaseException(String message) {
        super(message);
    }

    public DatabaseException(String message, int ... resources) {
        super(message);
        int[] nArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            int r = nArray[n2];
            this.addIndex(r);
            ++n2;
        }
    }

    public DatabaseException(int ... resources) {
        int[] nArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            int r = nArray[n2];
            this.addIndex(r);
            ++n2;
        }
    }

    public DatabaseException(Throwable cause) {
        super(cause);
    }

    public void addResource(Resource resource) {
        assert (resource != null);
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.add(resource);
    }

    public void addIndex(int index) {
        assert (index != 0);
        if (this.indices == null) {
            this.indices = new ArrayList();
        }
        this.indices.add(index);
    }

    public int getIndex(int index) {
        return this.indices.get(index);
    }

    public Collection<Resource> getResources() {
        return this.resources;
    }

    public void setNames(ArrayList<String> names) {
        this.names = names;
    }

    public <T extends Throwable> void throwCause(Class<T> clazz) throws T {
        Throwable t = this.getCause();
        if (t == null) {
            return;
        }
        if (clazz.isInstance(t)) {
            throw t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException("See cause for the real exception.", t);
    }

    public DatabaseException newStack() {
        return new DatabaseException(this);
    }

    @Override
    public String toString() {
        if (this.names != null) {
            System.out.println(this.names);
        }
        return super.toString();
    }

    public String getShortExplanation() {
        return this.getMessage();
    }

    public String getExplanation(ReadGraph graph) throws DatabaseException {
        return this.getShortExplanation();
    }
}

