package org.simantics.db.testing.common;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;

abstract public class ReadCommand<T extends CommandSequenceEnvironment> extends Command<T> {

	@Override
	public void run(final T environment) throws Exception {
		environment.getSession().sync(new ReadRequest() {

			@Override
			public void run(ReadGraph graph) throws DatabaseException {
				ReadCommand.this.run(graph, environment);
			}
			
		});
	}
	
	protected void run(ReadGraph graph, T environment) throws DatabaseException {
		
	}

}
