package org.simantics.db.testing.base;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.junit.Assert;
import org.simantics.db.testing.cases.FreshWorkspaceTest;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.TestScriptExecutor;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.utils.FileUtils;

public class ScriptTestBase  extends FreshWorkspaceTest {
    

    String path;

    public ScriptTestBase(String path) {
        this.path = path;
    }    

    /**
     * Runs a test case without a timeout
     */
    protected void test() {
    	
    	String testPath = getTestPath();
    	test(0, testPath);
    }
    
    /**
     * Runs a test case with given timeout as seconds.
     * 
     * @param allowedExecutionTime allowed execution time given in seconds.
     */
    protected void test(int allowedExecutionTime) {
    	
    	String testPath = getTestPath();
    	test(allowedExecutionTime, testPath);
    }

    /**
     * Runs a test case with given timeout as seconds. When the time runs out, heapdump and threaddump of the java process is taken and stored to the current workspace.
     * The workspace is being compressed to a Zip-file and then copied and stored to the current working directory. In the end the whole java process gets killed to prevent deadlocks.
     * 
     * @param allowedExecutionTime allowed execution time given in seconds.
     */
    protected void test(final int allowedExecutionTime, final String testPath) {
    	
    	if(allowedExecutionTime > 0) {
    		Timer timer = new Timer();
    		try {
    		timer.schedule(new TimerTask() {

				@Override
				public void run() {
					
					try {
						String workingDir = System.getProperty("user.dir");
						Location location = Platform.getInstanceLocation();
						String workspacePath = location.getURL().getPath().substring(1);
						String[] pathToWorkspace = workspacePath.split("/");
//						String[] testName = testPath.split("/");
						
//						String hdumpFileName = workspacePath + testName[testName.length - 1] + ".hprof";
//						GetHeapDump.dumpHeap(hdumpFileName, false);
						
//						String tdumpFileName = workspacePath + testName[testName.length - 1] + ".tdump";
//						GetThreadDump.dumpThread(tdumpFileName);
						
						SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyy_HH.mm.ss");
						String date = sdf.format(new Date());
						String zipDir = workingDir + "/" + pathToWorkspace[pathToWorkspace.length - 1] + "_" + date +  ".zip";
						FileUtils.compressZip(workspacePath, zipDir);
						
						String processName = ManagementFactory.getRuntimeMXBean().getName();
						System.out.println("PID: " + processName);
						String PID = processName.split("@")[0];
						String command = "taskkill /F /PID " + PID;
						System.out.println("Command: " + command);
						Runtime.getRuntime().exec(command);

					} catch (IOException ioe) {
						ioe.printStackTrace();
						System.err.println(ioe);
					}
					
				}
    		}, 1000*allowedExecutionTime);
    		testImpl(testPath);
    		} finally {
    			timer.cancel();	
    		}
    	} else {
    		testImpl(testPath);
    	}
    	
    }

    protected void testImpl(String testPath) {
    	
    	System.out.println("Testing script: " + testPath);

        InputStream stream = getClass().getResourceAsStream(testPath);
        if(stream == null)
            Assert.fail("Didn't find " + testPath + " at " + getClass().getResource(""));
        try {
            CommandSession session = new CommandSession(SCLOsgi.MODULE_REPOSITORY, null);
            TestScriptExecutor executor = new TestScriptExecutor(session,
                    new BufferedReader(new InputStreamReader(stream)), null);
            executor.execute();
            //isDBLogClean();
        } catch(IOException e) {
            throw new RuntimeException(e);
        } finally {
            try {
                stream.close();
            } catch (IOException e) {
            }
        }
    }
    
    public String getTestPath() {
    	
    	String methodName = new Exception().getStackTrace()[2].getMethodName();
        String testPath = path + "/" + methodName + ".sts";
    	
    	return testPath;
    }
    
    public void isDBLogClean() throws IOException {
    	
    	String workingDir = System.getProperty("user.dir");
    	try (BufferedReader br = new BufferedReader(new FileReader(workingDir + "/db-client.log"))) {
    		Assert.assertEquals(br.readLine(), null);
    	}
    	
    }
    
}