package org.simantics.db.service;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class ClusterUID {
    public static final ClusterUID Null = new ClusterUID(0, 0);
    public static final ClusterUID Reserved = new ClusterUID(0, 1);
    public static final ClusterUID Builtin = new ClusterUID(0, 2);
    public static boolean isLegal(ClusterUID clusterUID) {
        return !clusterUID.equals(Null) && !clusterUID.equals(Reserved);
    }
//    public final long first;
    public final long second;
//    public transient int arrayOffset = -1;

//    transient private static long firstCache1 = 0;
//    transient private static long firstCache2 = 0;
    transient private static long secondCache1 = 0;
    transient private static long secondCache2 = 0;
    transient private static ClusterUID clusterCache1 = null;
    transient private static ClusterUID clusterCache2 = null;

    public ClusterUID() {
//        first = 0;
        second = 0;
    }

    public ClusterUID(long first, long second) {
    	assert(first == 0);
//        this.first = first;
        this.second = second;
    }

    public synchronized static ClusterUID make(long first, long second) {

    	assert(first == 0);

        if(second == secondCache1) return clusterCache1;
        else if(second == secondCache2) return clusterCache2;
        else {
            ClusterUID result = new ClusterUID(first, second);
            secondCache2 = secondCache1; clusterCache2 = clusterCache1;
            secondCache1 = second; clusterCache1 = result;
            return result;
        }

    }

    public static ClusterUID make(byte[] bytes, int offset) {
        if (bytes.length < offset + 16)
            throw new IllegalArgumentException("Too few bytes for ClusteUID. length=" + bytes.length + " offset=" + offset);
        ByteBuffer bf = ByteBuffer.wrap(bytes, offset, 16);
        bf.order(ByteOrder.LITTLE_ENDIAN);
        return make(bf.getLong(),bf.getLong());
    }

    @Override
    public String toString() {
        return String.format("%x.%x", 0, second);
    }
    public static int getLongLength() {
        return 2;
    }
    public int toByte(byte[] bytes, int offset) {
        Bytes.writeLE(bytes, offset+0, 0);
        Bytes.writeLE(bytes, offset+8, second);
        return offset + 16;
    }
    public int toLong(long[] longs, int offset) {
        longs[offset++] = 0;
        longs[offset++] = second;
        return offset;
    }
    public byte[] asBytes() {
        byte[] bytes = new byte[16];
        toByte(bytes, 0);
        return bytes;
    }
    public ResourceUID toRID(int resourceIndex) {
        return new ResourceUID(0, second, resourceIndex);
    }
    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        else if (!(o instanceof ClusterUID))
            return false;
        ClusterUID x = (ClusterUID)o;
        return /*first == x.first &&*/ second == x.second;
    }
    @Override
    public int hashCode() {
        int result = 17;
//        int f = (int)(0 ^ (0 >>> 32));
//        result = 31 * result + f;
        int s = (int)(second ^ (second >>> 32));
        result = 31 * result + s;
        return result;
    }
}
