/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;

import java.nio.ByteOrder;

public class GetServerInfo2Function extends AbstractFunction {
    public long firstChangeSetId = 0;
    public String serverId = "";
    public String protocolId = "";
    public String databaseId = "";
    public GetServerInfo2Function() {
        super(MessageNumber.GetServerInfo2Request, MessageNumber.GetServerInfo2Response);
    }
    @Override
    public DataBuffer serialize(ByteOrder byteOrder) {
        buffer.clear();
        buffer.order(byteOrder);
        buffer.mark();
        return buffer;
    }
    @Override
    public void deserialize(int receivedNumber_, DataBuffer dataBuffer) {
        receivedNumber = receivedNumber_;
        if (notRightDataForUs())
            return;
        firstChangeSetId = dataBuffer.get(firstChangeSetId);
        serverId = dataBuffer.get(serverId);
        protocolId = dataBuffer.get(protocolId);
        databaseId = dataBuffer.get(databaseId);
        gotResponse();
    }
}
