/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.server.protocol;


public abstract class AbstractFunction extends AbstractMessage {
    private int token = 0;
    void setToken(int token) {
        this.token = token;
    }
    int getToken() {
        return token;
    }
    AbstractFunction(int requestNumber, int responseNumber) {
        super(requestNumber, responseNumber);
    }
    AbstractFunction(int requestNumber, int responseNumber, DataBuffer buffer) {
        super(requestNumber, responseNumber, buffer);
    }
    @Override
    boolean isEvent() {
        return false;
    }
    @Override
    String getExceptionText() {
        String t = super.getExceptionText();
        if (t != null)
            return super.getExceptionText();
        else if (notRightDataForUs())
            return "Response type does not match.";
        return null;
    }
    public boolean hasException() { // Used by return handler.
        return notRightDataForUs() || super.getExceptionText() != null;
    }
    boolean notRightDataForUs() {
        return receivedNumber != responseNumber;
    }
    void prepareForSendingRequest() {
        receivedNumber = 0;
        responsePending = true;
        super.setExceptionText(null);
    }
    boolean hasResponsePending() {
        return hasResponse() && responsePending;
    }
    synchronized void gotResponse() {
        responsePending = false;
        this.notify();
    }
//    synchronized void waitForResponse(Connection connection, long waitMs) throws SessionException {
//        String string = "AbstractFunction.waitForResponse";
//        if (DebugPolicy.REPORT_TIME_CONSUMING_FUNCTIONS)
//            string += "token=" + token + ", returnHandler=" + returnHandler;
//        DebugPolicy.wait(waitMs, this, string);
//    }
}
