/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.procore.cluster.ClusterTraitsSmall;
import org.simantics.db.procore.cluster.CompleteTable;

public class CompleteTableSmall
extends CompleteTable {
    public CompleteTableSmall(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(sizeListener, header, headerBase);
    }

    public CompleteTableSmall(TableSizeListener sizeListener, int[] header, int headerBase, int[] ints) {
        super(sizeListener, header, headerBase, ints);
    }

    @Override
    public <Context> boolean foreachPredicate(int setIndex, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        ForeachPredicate<Context> t = new ForeachPredicate<Context>(procedure, support, modifier);
        return this.foreachComplete(setIndex, t, context, null, null);
    }

    @Override
    public <Context> boolean foreachObject(int setIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier, ClusterI.CompleteTypeEnum completeType) throws DatabaseException {
        ForeachObject<Context> t = new ForeachObject<Context>(procedure, support, modifier, completeType);
        return this.foreachComplete(setIndex, t, context, null, null);
    }

    private static class ForeachObject<Context>
    implements ClusterI.ObjectProcedure<Context> {
        private ClusterI.ObjectProcedure<Context> procedure;
        private Modifier modifier;
        private ClusterI.CompleteTypeEnum completeType;

        public ForeachObject(ClusterI.ObjectProcedure<Context> procedure, ClusterSupport support, Modifier modifier, ClusterI.CompleteTypeEnum completeType) {
            this.procedure = procedure;
            this.modifier = modifier;
            this.completeType = completeType;
        }

        public boolean execute(Context context, int completeRef) throws DatabaseException {
            ClusterI.CompleteTypeEnum completeType2 = ClusterTraitsSmall.completeRefAndTypeGetType(completeRef);
            if (this.completeType == completeType2) {
                int objectRef = ClusterTraitsSmall.completeRefAndTypeGetRef(completeRef);
                int externalRef = this.modifier == null ? objectRef : this.modifier.execute(objectRef);
                return this.procedure.execute(context, externalRef);
            }
            return false;
        }
    }

    private static final class ForeachPredicate<Context>
    implements ClusterI.ObjectProcedure<Context> {
        private TIntHashSet completeTypes = new TIntHashSet();
        private ClusterI.PredicateProcedure<Context> procedure;

        public ForeachPredicate(ClusterI.PredicateProcedure<Context> procedure, ClusterSupport support, Modifier modifier) {
            this.procedure = procedure;
        }

        public boolean execute(Context context, int completeRef) {
            ClusterI.CompleteTypeEnum completeType = ClusterTraitsSmall.completeRefAndTypeGetType(completeRef);
            if (!this.completeTypes.contains((int)completeType.getValue())) {
                this.completeTypes.add((int)completeType.getValue());
                try {
                    int pKey = ClusterTraitsBase.getCompleteTypeResourceKeyFromEnum((ClusterI.CompleteTypeEnum)completeType);
                    if (this.procedure.execute(context, pKey, 0)) {
                        return true;
                    }
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return false;
        }
    }
}

