/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterTraitsBase;

public final class ClusterTraits
extends ClusterTraitsBase {
    private static final int FOREIGN_INDEX_BITS = 16;
    private static final int FOREIGN_INDEX_MAX = 65535;
    private static final int CLUSTER_INDEX_BITS = 16;
    private static final int CLUSTER_INDEX_MAX = 65535;
    private static final int TYPE_BITS = 2;
    private static final int NOTYPE_BITS = 30;

    public static final int createForeignReference(int foreignIndex, int resourceIndex) throws DatabaseException {
        if (foreignIndex < 1 || foreignIndex > 65535) {
            throw new DatabaseException("Illegal foreign index " + foreignIndex);
        }
        if (ClusterTraits.isIllegalResourceIndex((int)resourceIndex)) {
            throw new DatabaseException("Illegal resource index " + resourceIndex);
        }
        return resourceIndex << 16 | foreignIndex | Integer.MIN_VALUE;
    }

    public static int referenceGetType(int ref) {
        return ref >>> 30;
    }

    public static final boolean isFlat(int reference) {
        return reference < 0 && (reference & 0x40000000) != 0;
    }

    public static final boolean isLocal(int reference) {
        return (reference & 0xC0000000) == 0;
    }

    public static final int getForeignIndexFromReference(int reference) throws DatabaseException {
        int foreignIndex = reference & 0xFFFF;
        if (foreignIndex == 0) {
            throw new DatabaseException("Illegal foreign index " + foreignIndex);
        }
        return foreignIndex;
    }

    public static final int getResourceIndexFromForeignReference(int reference) throws DatabaseException {
        int resourceIndex = (reference & Integer.MAX_VALUE) >> 16;
        if (ClusterTraits.isIllegalResourceIndex((int)resourceIndex)) {
            throw new DatabaseException("Illegal foreign reference " + reference);
        }
        return resourceIndex;
    }

    public static final boolean statementIndexIsDirect(int index) {
        return (index & 0xC0000000) != 0x40000000;
    }

    public static final int statementIndexMake(int index) throws DatabaseException {
        assert (index > 0);
        if ((index & 0xC0000000) != 0) {
            throw new DatabaseException("Illegal statement index " + index);
        }
        return index | 0x40000000;
    }

    public static final int statementIndexGet(int index) throws DatabaseException {
        if ((index & 0xC0000000) == 0x40000000) {
            return index & 0x3FFFFFFF;
        }
        return index;
    }

    public static boolean completeReferenceIsLocal(int completeRef) {
        boolean complete;
        boolean bl = complete = (completeRef & 0xC0000000) != 0;
        return complete && (completeRef & 0xFFFF) == 0;
    }

    public static boolean completeReferenceIsMultiple(int completeRef) {
        boolean complete;
        boolean bl = complete = (completeRef & 0xC0000000) != 0;
        return !complete && completeRef != 0;
    }

    public static int completeReferenceGetResourceIndex(int completeRef) {
        int low = (completeRef & 0x3FFFFFFF) >>> 16;
        return low & 0x3FFFF;
    }

    public static int completeReferenceGetForeignIndex(int completeRef) {
        return completeRef & 0xFFFF;
    }

    public static ClusterI.CompleteTypeEnum completeReferenceGetType(int completeRef) {
        return ClusterI.CompleteTypeEnum.make((int)(completeRef >>> 30));
    }

    public static int completeReferenceMake(int type, int resourceIndex, int clusterIndex) {
        assert (type < 4);
        assert (!ClusterTraits.isIllegalResourceIndex((int)resourceIndex));
        assert (clusterIndex <= 65535);
        int ref = type << 30 | resourceIndex << 16 | clusterIndex;
        return ref;
    }

    public static int completeReferenceMake(int type, int setIndex) {
        assert (type < 4);
        assert (setIndex < 0x40000000);
        int ref = type << 30 | setIndex;
        return ref;
    }
}

