/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.util.concurrent.Semaphore;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.WriteTraits;

public class WriteStateBase<T> {
    protected final WriteTraits request;
    protected final Semaphore notify;
    protected final Procedure<T> procedure;
    protected T result;
    protected Throwable exception;

    public WriteStateBase(WriteTraits request, Semaphore notify, Procedure<T> procedure) {
        assert (request != null);
        this.request = request;
        this.notify = notify;
        this.procedure = procedure;
    }

    public WriteTraits getRequest() {
        return this.request;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void except(Throwable throwable) {
        this.exception = throwable;
    }

    public boolean isExcepted() {
        return this.exception != null;
    }

    public void finish() {
        if (this.procedure != null) {
            try {
                if (this.procedure != null) {
                    if (this.isExcepted()) {
                        if (this.exception instanceof DatabaseException) {
                            this.procedure.exception(this.exception);
                        } else {
                            this.procedure.exception((Throwable)new DatabaseException(this.exception));
                        }
                    } else {
                        this.procedure.execute(this.result);
                    }
                }
            }
            catch (Throwable t) {
                Logger.defaultLogError((String)"Write request callback caused an unexpected error, see exception.", (Throwable)t);
            }
        }
        if (this.notify != null) {
            this.notify.release();
        }
    }
}

