/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.State;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.db.Session;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.common.TransactionPolicyRelease;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.exception.TimeoutException;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.TransactionPolicySupport;

public class LifecycleSupportImpl
implements LifecycleSupport {
    private final SessionImplSocket session;
    private final CopyOnWriteArrayList<LifecycleSupport.LifecycleListener> listeners = new CopyOnWriteArrayList();

    LifecycleSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public long getId() {
        return this.session.graphSession.getSessionId();
    }

    public boolean isClosing() {
        return this.session.state.isClosing();
    }

    public boolean isClosed() {
        return this.session.state.isClosed();
    }

    public final SessionReference getSessionReference() {
        if (this.session.graphSession == null) {
            return null;
        }
        return this.session.graphSession.getSessionReference();
    }

    public final SessionManager getSessionManager() {
        return this.session.sessionManagerImpl;
    }

    public void ping() throws DatabaseException {
        this.session.graphSession.execute("");
    }

    public void close() throws DatabaseException {
        block12: {
            GraphSession graphSession = this.session.graphSession;
            try {
                try {
                    this.close(0L, false);
                }
                catch (TimeoutException timeoutException) {
                    this.close(-1L, true);
                    if (graphSession == null) break block12;
                    try {
                        graphSession.stop();
                    }
                    catch (InternalException e) {
                        Logger.defaultLogError((String)"GraphSession.stop failed.", (Throwable)e);
                    }
                }
            }
            finally {
                if (graphSession != null) {
                    try {
                        graphSession.stop();
                    }
                    catch (InternalException e) {
                        Logger.defaultLogError((String)"GraphSession.stop failed.", (Throwable)e);
                    }
                }
            }
        }
    }

    public final void close(long timeout, boolean force) throws DatabaseException {
        this.session.registerService(TransactionPolicySupport.class, new TransactionPolicyRelease());
        State.WaitStatus status = this.session.state.waitClosing(timeout);
        switch (status) {
            case IsClosed: 
            case IsClosing: {
                return;
            }
            case Timeout: {
                if (!force) {
                    throw new TimeoutException("Close timeout, use force!");
                }
            }
            case CanBeClosed: {
                try {
                    QueryProcessor prosessor = this.session.getQueryProvider2();
                    if (prosessor != null) {
                        prosessor.dispose();
                    }
                    this.session.virtualGraphServerSupport.disposeVirtualGraphs();
                    this.session.removeTemporaryData();
                    this.session.graphSession.close();
                    this.session.serviceLocator.dispose();
                    break;
                }
                finally {
                    this.session.state.close();
                    this.session.clusterTable.dispose();
                    this.session.clusterTable = null;
                    this.session.sessionManagerImpl.shutdown((Session)this.session, null);
                    this.session.sessionManagerImpl = null;
                    this.session.user = null;
                    this.session.graphSession = null;
                }
            }
            default: {
                throw new DatabaseException();
            }
        }
    }

    public void addListener(LifecycleSupport.LifecycleListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LifecycleSupport.LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    void fireListeners(LifecycleSupport.LifecycleState newState) {
        for (LifecycleSupport.LifecycleListener listener : this.listeners) {
            listener.stateChanged(newState);
        }
    }
}

