/*******************************************************************************
 * Copyright (c) 2015 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.variable;

import org.simantics.simulator.variable.NodeManager;

/**
 * A type of Runnable used to identify {@link VariableNode} and
 * {@link NodeManager} related system-internal requests that are intended only
 * for reading data from the solver variable nodes in the Simantics
 * {@link Variable} subsystem.
 * 
 * <p>
 * The only real internal examples of these system-internal read operations are
 * {@link NodeStructureRequest} and {@link NodeValueRequest}.
 * 
 * @author Tuukka Lehtonen
 */
public interface VariableNodeReadRunnable extends Runnable {
}
