/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.util;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * TODO: is this useful? Doesn't seem to be used.
 */
public class RelationUtils {

	public static Resource[] createRelation(WriteGraph g, String name, String inverseName, Resource baseRelation) throws DatabaseException {
		Layer0 b = Layer0.getInstance(g);
		Resource newRelation = g.newResource();
		g.claim(newRelation, b.SubrelationOf, baseRelation);
		if(name != null)
			g.claimLiteral(newRelation,b.HasName, name);
		Resource newInverse = g.newResource();
		g.claim(newInverse, b.SubrelationOf, g.getInverse(baseRelation));
		g.claim(newRelation, b.InverseOf, newInverse);
		if (inverseName != null)
			g.claimLiteral(newInverse, b.HasName,inverseName);

		return new Resource[] {newRelation, newInverse};
	}
	
}
