package org.simantics.db.layer0.scl;

import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.compiler.errors.CompilationError;

public class SCLDatabaseException extends DatabaseException {

	private static final long serialVersionUID = 7276869582177709334L;
	
	final public String shortExplanation;
	final public CompilationError[] compilationErrors;
	
	public SCLDatabaseException(String message, String shortExplanation, CompilationError[] compilationErrors) {
		super(message);
		this.shortExplanation = shortExplanation;
		this.compilationErrors = compilationErrors;
	}

	@Override
	public String getShortExplanation() {
		return shortExplanation;
	}
	
}
