/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.OntologyVersions;

public class PossibleDiagram extends ResourceRead<Resource> {

    public PossibleDiagram(Resource component) {
        super(component);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {

        Layer0 l0 = Layer0.getInstance(graph);
        String uri = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Modeling-0.0/ComponentToElement");
        Resource map = graph.getResource(uri);
        if(map == null)
            return null;

        Resource element = graph.getPossibleObject(resource, map);
        if (element == null)
            return null;

        return OrderedSetUtils.getSingleOwnerList(graph, element, l0.OrderedSet);

    }

}
