package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.user.UserResource;

public class IsUserInGroup extends ResourceRead2<Boolean> {

    public IsUserInGroup(Resource user, Resource group) {
        super(user, group);
    }
    
    @Override
    public Boolean perform(ReadGraph graph) throws DatabaseException {
        UserResource USER = UserResource.getInstance(graph);
        if(resource.equals(resource2)) return true;
        for(Resource part : graph.getObjects(resource2, USER.Group_Contains)) {
            if(graph.syncRequest(new IsUserInGroup(resource, part))) return true;
        }
        return false;
    }
    
}