/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.migration;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.graph.representation.Root;
import org.simantics.simulation.ontology.SimulationResource;

public class ModelImportAdvisor extends DefaultPasteImportAdvisor {

	public ModelImportAdvisor(Resource library) {
		super(library);
	}

	public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {

		SimulationResource SIMU = SimulationResource.getInstance(graph);
		Resource typeResource = graph.getResource(root.type);
		if(graph.isInheritedFrom(typeResource, SIMU.Model)) {
			library = SimanticsInternal.getProject();
		}
		
	}
    
}
