/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.migration;

import java.io.PrintWriter;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Session;
import org.simantics.graph.db.ImportResult;

public interface MigrationStateKeys {

    /**
     * @see Session
     */
    public final static String SESSION = "session";
    /**
     * @see IProgressMonitor
     */
    public final static String PROGRESS_MONITOR = "progressMonitor";
	public final static String BASE_URI = "baseURI";
    public final static String MODEL_FILE = "modelFile";
	public final static String CURRENT_TG = "currentTG";
    public final static String CURRENT_TGS = "currentTGS";
    
    public final static String GET_RESOURCE_IDS = "getResourceIds";
    public final static String RESOURCE_IDS = "resourceIds";

    /**
     * If this key is set, any messages logged by the migration process shall be
     * written into the associated {@link PrintWriter} instance.
     * 
     * @see NullWriter
     */
    public final static String MESSAGE_LOG_WRITER = "messageLogWriter";

    /**
     * The reader used to support {@link #CURRENT_TGS}. Must be closed when
     * state is disposed.
     */
    public final static String CURRENT_TGS_READER = "currentTGSReader";
	public final static String CURRENT_DATA_CONTAINER = "currentDataContainer";
	public final static String TG_EXTENSIONS = "tgExtensions";
	public final static String CURRENT_RESOURCE = "currentResource";
	public final static String IMPORT_ADVISOR = "importAdvisor";

    /**
     * Used for storing the {@link ImportResult} resulting from the TG import.
     */
    public final static String IMPORT_RESULT = "importResult";

    /**
     * All root resources of the imported material as
     * Collection&lt;Resource&gt;.
     */
    public final static String CURRENT_ROOT_RESOURCES = "currentRootResources";
    /**
     * This is a hint that informs migration procedures whether they should
     * disable dependency index updates in database requests they perform.
     * Expects Boolean value and defaults to <code>true</code> if not defined.
     */
    public final static String UPDATE_DEPENDENCIES = "updateDependencies";

    /**
     * The database revision ID right after importing the transferable graph (
     * {@link #CURRENT_TG} or {@link #CURRENT_TGS}) into the database which
     * occurs when {@link #CURRENT_RESOURCE} or {@link #CURRENT_ROOT_RESOURCES}
     * is asked for the first time.
     */
    public final static String DATABASE_REVISION_AFTER_TG_IMPORT = "revisionAfterTgImport";

}
