/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;

/**
 * A {@link Remover} implementation that never allows removal. It uses the
 * provided String as a reason for not allowing removal in
 * {@link #canRemove(ReadGraph, java.util.Map)}
 * 
 * @author Tuukka Lehtonen
 */
public class FailingRemover implements Remover {

	String reason;

	public FailingRemover(String reason) throws DatabaseException {
		this.reason = reason;
	}

	public String canRemove(ReadGraph graph, java.util.Map<Object,Object> aux) {
		return reason;
	};

	@Override
	public void remove(WriteGraph graph) throws DatabaseException {
	}

}
