package org.simantics.db.layer0.adapter;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.SimanticsClipboard;

abstract public class PasteHandlerAdapter implements PasteHandler {

	@Override
	public Collection<Resource> pasteFromClipboard(final SimanticsClipboard clipboard) throws DatabaseException {
    	return SimanticsInternal.getSession().syncRequest(new WriteResultRequest<Collection<Resource>>() {

			@Override
			public Collection<Resource> perform(WriteGraph graph) throws DatabaseException {
				return pasteFromClipboard(graph, clipboard, null);
			}
    		
    	});
	}

}
