package org.simantics.db.layer0.adapter;

import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;

abstract public class AbstractStringModifier implements StringModifier {

	final private Resource value;
	
	public AbstractStringModifier(Resource resource) {
		this.value = resource;
	}
	
	@Override
	public String getValue() {
		try {
          return SimanticsInternal.getSession().syncRequest(new PossibleAdapter<String>(value, String.class));
      } catch (DatabaseException e) {
          Logger.defaultLogError(e);
          return null;
      }
	}
	
}
