/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoInverseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.ReadGraphSupport;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.procedure.TripleIntProcedureAdapter;
import org.simantics.db.impl.query.AsyncMultiReadEntry;
import org.simantics.db.impl.query.AsyncReadEntry;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.ExternalReadEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.ListenerEntry;
import org.simantics.db.impl.query.MultiReadEntry;
import org.simantics.db.impl.query.ObjectUpdateSet;
import org.simantics.db.impl.query.Objects;
import org.simantics.db.impl.query.OrderedSet;
import org.simantics.db.impl.query.PossibleSuperRelation;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryCacheBase;
import org.simantics.db.impl.query.QueryCollectorImpl;
import org.simantics.db.impl.query.QueryCollectorImpl2;
import org.simantics.db.impl.query.QueryListening;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.QueryThread;
import org.simantics.db.impl.query.ReadEntry;
import org.simantics.db.impl.query.Scheduling;
import org.simantics.db.impl.query.Statements;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.impl.query.Types;
import org.simantics.db.impl.query.UpdateEntry;
import org.simantics.db.impl.query.ValueQuery;
import org.simantics.db.impl.query.ValueUpdateSet;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procedure.AsyncMultiListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.AsyncSetListener;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.MultiProcedure;
import org.simantics.db.procedure.StatementProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.layer0.Layer0;
import org.simantics.utils.DataContainer;
import org.simantics.utils.Development;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;

public final class QueryProcessor
extends AbstractDisposable
implements ReadGraphSupport {
    public static int indent = 0;
    public int boundQueries = 0;
    private final int functionalRelation;
    private final int superrelationOf;
    private final int instanceOf;
    private final int inverseOf;
    private final int asserts;
    private final int hasPredicate;
    private final int hasPredicateInverse;
    private final int hasObject;
    private final int inherits;
    private final int subrelationOf;
    private final int rootLibrary;
    private volatile ResourceImpl rootLibraryResource;
    private final int library;
    private final int consistsOf;
    private final int hasName;
    AtomicInteger sleepers = new AtomicInteger(0);
    boolean updating = false;
    public final QueryCache cache;
    public final QuerySupport querySupport;
    public final Session session;
    public final ResourceSupport resourceSupport;
    public final Semaphore requests = new Semaphore(1);
    public final QueryListening listening = new QueryListening(this);
    QueryThread[] executors;
    final Scheduling scheduling;
    public ThreadState[] threadStates;
    final Object querySupportLock;
    public Long modificationCounter = 0L;
    final int THREADS;
    public final int THREAD_MASK;
    public static final ThreadGroup QueryThreadGroup = new ThreadGroup("Query Thread Group");
    private static final Dummy dummy = new Dummy();
    private QueryCollectorSupport collectorSupport = new QueryCollectorSupportImpl();
    private QueryCollector collector = new QueryCollectorImpl(this, this.collectorSupport);
    private ObjectUpdateSet scheduledObjectUpdates = new ObjectUpdateSet();
    private ValueUpdateSet scheduledValueUpdates = new ValueUpdateSet();
    private ValueUpdateSet scheduledInvalidates = new ValueUpdateSet();
    private Object primitiveUpdateLock = new Object();
    private THashSet scheduledPrimitiveUpdates = new THashSet();
    private ArrayList<CacheEntry> refutations = new ArrayList();
    private int lastInvalidate = 0;
    private HashMap<Resource, Class<?>> builtinValues;
    Exception callerException = null;
    private static final Resource INVALID_RESOURCE = new ResourceImpl(null, Integer.MIN_VALUE);
    private Layer0 L0;
    public static ThreadLocal<Integer> thread = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return -1;
        }
    };

    public void close() {
    }

    public boolean performPending(ReadGraphImpl under) {
        SessionTask task = this.scheduling.getSubTask(under);
        if (task != null) {
            task.run(thread.get());
            return true;
        }
        return false;
    }

    public final void scheduleNow(SessionTask request) {
        SessionTask toExecute = this.scheduleOrReturnForExecution(request);
        if (toExecute != null) {
            toExecute.run(thread.get());
        }
    }

    public final SessionTask scheduleOrReturnForExecution(SessionTask request) {
        return this.scheduling.scheduleOrReturnForExecution(request);
    }

    public boolean resume(ReadGraphImpl graph) {
        return this.executors[0].runSynchronized();
    }

    public QueryProcessor(int threads, QuerySupport core, Set<Thread> threadSet) throws DatabaseException {
        boolean builtinsInstalled;
        this.THREADS = threads;
        this.THREAD_MASK = threads - 1;
        this.scheduling = new Scheduling(this.requests);
        this.querySupport = core;
        this.cache = new QueryCache(core, threads);
        this.session = this.querySupport.getSession();
        this.resourceSupport = this.querySupport.getSupport();
        this.querySupportLock = core.getLock();
        this.executors = new QueryThread[this.THREADS];
        this.threadStates = new ThreadState[this.THREADS];
        int i = 0;
        while (i < this.THREADS) {
            this.threadStates[i] = ThreadState.INIT;
            ++i;
        }
        i = 0;
        while (i < this.THREADS) {
            int index = i;
            this.executors[i] = new QueryThread(this.session, this, index, "Query Thread " + index);
            threadSet.add(this.executors[i]);
            ++i;
        }
        i = 0;
        while (i < this.THREADS) {
            this.executors[i].start();
            ++i;
        }
        while (this.sleepers.get() != this.THREADS) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.rootLibrary = core.getBuiltin("http:/");
        boolean bl = builtinsInstalled = this.rootLibrary != 0;
        if (builtinsInstalled) {
            this.functionalRelation = core.getBuiltin("http://www.simantics.org/Layer0-1.1/FunctionalRelation");
            assert (this.functionalRelation != 0);
        } else {
            this.functionalRelation = 0;
        }
        if (builtinsInstalled) {
            this.instanceOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/InstanceOf");
            assert (this.instanceOf != 0);
        } else {
            this.instanceOf = 0;
        }
        if (builtinsInstalled) {
            this.inverseOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/InverseOf");
            assert (this.inverseOf != 0);
        } else {
            this.inverseOf = 0;
        }
        if (builtinsInstalled) {
            this.inherits = core.getBuiltin("http://www.simantics.org/Layer0-1.1/Inherits");
            assert (this.inherits != 0);
        } else {
            this.inherits = 0;
        }
        if (builtinsInstalled) {
            this.asserts = core.getBuiltin("http://www.simantics.org/Layer0-1.1/Asserts");
            assert (this.asserts != 0);
        } else {
            this.asserts = 0;
        }
        if (builtinsInstalled) {
            this.hasPredicate = core.getBuiltin("http://www.simantics.org/Layer0-1.1/HasPredicate");
            assert (this.hasPredicate != 0);
        } else {
            this.hasPredicate = 0;
        }
        if (builtinsInstalled) {
            this.hasPredicateInverse = core.getBuiltin("http://www.simantics.org/Layer0-1.1/HasPredicateInverse");
            assert (this.hasPredicateInverse != 0);
        } else {
            this.hasPredicateInverse = 0;
        }
        if (builtinsInstalled) {
            this.hasObject = core.getBuiltin("http://www.simantics.org/Layer0-1.1/HasObject");
            assert (this.hasObject != 0);
        } else {
            this.hasObject = 0;
        }
        if (builtinsInstalled) {
            this.subrelationOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/SubrelationOf");
            assert (this.subrelationOf != 0);
        } else {
            this.subrelationOf = 0;
        }
        if (builtinsInstalled) {
            this.superrelationOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/SuperrelationOf");
            assert (this.superrelationOf != 0);
        } else {
            this.superrelationOf = 0;
        }
        if (builtinsInstalled) {
            this.library = core.getBuiltin("http://www.simantics.org/Layer0-1.1/Library");
            assert (this.library != 0);
        } else {
            this.library = 0;
        }
        if (builtinsInstalled) {
            this.consistsOf = core.getBuiltin("http://www.simantics.org/Layer0-1.1/ConsistsOf");
            assert (this.consistsOf != 0);
        } else {
            this.consistsOf = 0;
        }
        if (builtinsInstalled) {
            this.hasName = core.getBuiltin("http://www.simantics.org/Layer0-1.1/HasName");
            assert (this.hasName != 0);
        } else {
            this.hasName = 0;
        }
    }

    public final void releaseWrite(ReadGraphImpl graph) {
        this.propagateChangesInQueryCache(graph);
        this.modificationCounter = this.modificationCounter + 1L;
    }

    public final int getId(Resource r) {
        return this.querySupport.getId(r);
    }

    public QuerySupport getCore() {
        return this.querySupport;
    }

    public int getFunctionalRelation() {
        return this.functionalRelation;
    }

    public int getInherits() {
        return this.inherits;
    }

    public int getInstanceOf() {
        return this.instanceOf;
    }

    public int getInverseOf() {
        return this.inverseOf;
    }

    public int getSubrelationOf() {
        return this.subrelationOf;
    }

    public int getSuperrelationOf() {
        return this.superrelationOf;
    }

    public int getAsserts() {
        return this.asserts;
    }

    public int getHasPredicate() {
        return this.hasPredicate;
    }

    public int getHasPredicateInverse() {
        return this.hasPredicateInverse;
    }

    public int getHasObject() {
        return this.hasObject;
    }

    public int getRootLibrary() {
        return this.rootLibrary;
    }

    public Resource getRootLibraryResource() {
        if (this.rootLibraryResource == null) {
            int root = this.getRootLibrary();
            if (root == 0) {
                throw new UnsupportedOperationException("database is not initialized, cannot get root library resource");
            }
            this.rootLibraryResource = new ResourceImpl(this.querySupport.getSupport(), root);
        }
        return this.rootLibraryResource;
    }

    public int getLibrary() {
        return this.library;
    }

    public int getConsistsOf() {
        return this.consistsOf;
    }

    public int getHasName() {
        return this.hasName;
    }

    public void forResource(ReadGraphImpl graph, final String id, CacheEntry parent, final InternalProcedure<Integer> procedure) {
        try {
            QueryCache.runnerURIToResource(graph, id, parent, null, new InternalProcedure<Integer>(){

                @Override
                public void execute(ReadGraphImpl graph, Integer result) throws DatabaseException {
                    if (result != null && result != 0) {
                        procedure.execute(graph, result);
                        return;
                    }
                    if (result != 0) {
                        procedure.execute(graph, result);
                    } else {
                        procedure.exception(graph, (Throwable)new ResourceNotFoundException(id));
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                    procedure.exception(graph, t);
                }
            });
        }
        catch (DatabaseException e) {
            try {
                procedure.exception(graph, e);
            }
            catch (DatabaseException e1) {
                Logger.defaultLogError((Throwable)e1);
            }
        }
    }

    public void forBuiltin(ReadGraphImpl graph, String id, CacheEntry parent, InternalProcedure<Integer> procedure) throws DatabaseException {
        Integer result = this.querySupport.getBuiltin(id);
        if (result != 0) {
            procedure.execute(graph, result);
        } else {
            procedure.exception(graph, (Throwable)new ResourceNotFoundException(id));
        }
    }

    final <T> void runMultiRead(ReadGraphImpl graph, MultiReadEntry cached, MultiRead<T> query, CacheEntry parent, QueryProcessor provider, ListenerBase listener, SyncMultiProcedure<T> procedure) {
        try {
            QueryCache.runnerMultiReadEntry(graph, query, parent, listener, procedure);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    public final <T> void runAsyncMultiRead(ReadGraphImpl graph, AsyncMultiRead<T> query, CacheEntry parent, ListenerBase listener, AsyncMultiProcedure<T> procedure) {
        try {
            QueryCache.runnerAsyncMultiReadEntry(graph, query, parent, listener, procedure);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    final <T> void runPrimitiveRead(ReadGraphImpl graph, ExternalReadEntry cached, ExternalRead<T> query, CacheEntry parent, QueryProcessor provider, ListenerBase listener, AsyncProcedure<T> procedure) throws DatabaseException {
        QueryCache.runnerExternalReadEntry(graph, query, parent, listener, procedure);
    }

    public <T> void queryMultiRead(ReadGraphImpl graph, MultiRead<T> query, CacheEntry parent, ListenerBase listener, SyncMultiProcedure<T> procedure) throws DatabaseException {
        QueryCache.runnerMultiReadEntry(graph, query, parent, listener, procedure);
    }

    public <T> void queryPrimitiveRead(ReadGraphImpl graph, ExternalRead<T> query, CacheEntry parent, ListenerBase listener, AsyncProcedure<T> procedure) throws DatabaseException {
        QueryCache.runnerExternalReadEntry(graph, query, parent, listener, procedure);
    }

    boolean isBound(ExternalReadEntry<?> entry) {
        if (entry.hasParents()) {
            return true;
        }
        return this.listening.hasListener(entry);
    }

    public int querySize() {
        return this.cache.size;
    }

    public void gc(int youngTarget, int allowedTimeInMs) {
        this.collector.collect(youngTarget, allowedTimeInMs);
    }

    void processParentReport(CacheEntry entry, Map<CacheEntry, Set<CacheEntry>> workarea) {
        if (entry.isDiscarded()) {
            return;
        }
        if (workarea.containsKey(entry)) {
            return;
        }
        Iterable<CacheEntry<?>> parents = entry.getParents(this);
        HashSet ps = new HashSet();
        for (CacheEntry<?> e : parents) {
            if (e.isDiscarded()) continue;
            ps.add(e);
            this.processParentReport(e, workarea);
        }
        workarea.put(entry, ps);
    }

    public synchronized String reportQueryActivity(File file) throws IOException {
        System.err.println("reportQueries " + file.getAbsolutePath());
        if (!this.isAlive()) {
            return "Disposed!";
        }
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        List entries = CollectionUtils.valueSortedEntries((Map)Development.histogram);
        Collections.reverse(entries);
        for (Pair entry : entries) {
            b.println(String.valueOf((String)entry.first) + ": " + entry.second);
        }
        b.close();
        Development.histogram.clear();
        return "OK";
    }

    public synchronized String reportQueries(File file) throws IOException {
        System.err.println("reportQueries " + file.getAbsolutePath());
        if (!this.isAlive()) {
            return "Disposed!";
        }
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        long start = System.nanoTime();
        HashMap<CacheEntry, Set<CacheEntry>> workarea = new HashMap<CacheEntry, Set<CacheEntry>>();
        Collection<CacheEntryBase> caches = this.allCaches(new CacheCollectionResult()).toCollection();
        for (CacheEntryBase entry : caches) {
            this.processParentReport(entry, workarea);
        }
        long duration = System.nanoTime() - start;
        System.err.println("Query root set in " + 1.0E-9 * (double)duration + "s.");
        start = System.nanoTime();
        HashMap<CacheEntry, Integer> flagMap = new HashMap<CacheEntry, Integer>();
        int listeners = 0;
        for (CacheEntry entry : workarea.keySet()) {
            boolean listener = this.listening.hasListenerAfterDisposing(entry);
            boolean hasParents = entry.getParents(this).iterator().hasNext();
            if (listener) {
                flagMap.put(entry, 0);
                continue;
            }
            if (!hasParents) {
                flagMap.put(entry, 1);
                continue;
            }
            flagMap.put(entry, 2);
        }
        boolean done = true;
        int loops = 0;
        do {
            done = true;
            long start2 = System.nanoTime();
            int boundCounter = 0;
            int unboundCounter = 0;
            int unknownCounter = 0;
            for (CacheEntry cacheEntry : workarea.keySet()) {
                int flags = (Integer)flagMap.get(cacheEntry);
                int bindStatus = flags & 3;
                if (bindStatus == 0) {
                    ++boundCounter;
                } else if (bindStatus == 1) {
                    ++unboundCounter;
                } else if (bindStatus == 2) {
                    ++unknownCounter;
                }
                if (bindStatus < 2) continue;
                int newStatus = 1;
                for (CacheEntry<?> parent : cacheEntry.getParents(this)) {
                    int flags2;
                    int bindStatus2;
                    if (parent.isDiscarded()) {
                        flagMap.put(parent, 1);
                    }
                    if ((bindStatus2 = (flags2 = ((Integer)flagMap.get(parent)).intValue()) & 3) == 0) {
                        newStatus = 0;
                        break;
                    }
                    if (bindStatus2 != 2) continue;
                    newStatus = 2;
                    done = false;
                    break;
                }
                flagMap.put(cacheEntry, newStatus);
            }
            duration = System.nanoTime() - start2;
            System.err.println("Query analysis pass (" + boundCounter + "/" + unboundCounter + "/" + unknownCounter + ") in " + 1.0E-9 * (double)duration + "s.");
            b.println("Query analysis pass (" + boundCounter + "/" + unboundCounter + "/" + unknownCounter + ") in " + 1.0E-9 * (double)duration + "s.");
        } while (!done && loops++ < 20);
        if (loops >= 20) {
            for (CacheEntry entry : workarea.keySet()) {
                int bindStatus = (Integer)flagMap.get(entry);
                if (bindStatus != 2) continue;
                System.err.println("Undefined bind status for " + entry);
            }
        }
        duration = System.nanoTime() - start;
        System.err.println("Query analysis in " + 1.0E-9 * (double)duration + "s.");
        HashMap counts = new HashMap();
        for (CacheEntry entry : workarea.keySet()) {
            Class<?> clazz = entry.getClass();
            if (entry instanceof ReadEntry) {
                clazz = ((ReadEntry)entry).id.getClass();
            } else if (entry instanceof MultiReadEntry) {
                clazz = ((MultiReadEntry)entry).id.getClass();
            } else if (entry instanceof AsyncReadEntry) {
                clazz = ((AsyncReadEntry)entry).id.getClass();
            } else if (entry instanceof AsyncMultiReadEntry) {
                clazz = ((AsyncMultiReadEntry)entry).id.getClass();
            } else if (entry instanceof ExternalReadEntry) {
                clazz = ((ExternalReadEntry)entry).id.getClass();
            }
            Integer c = (Integer)counts.get(clazz);
            if (c == null) {
                counts.put(clazz, -1);
                continue;
            }
            counts.put(clazz, c - 1);
        }
        b.print("// Simantics DB client query report file\n");
        b.print("// This file contains the following information\n");
        b.print("// -The amount of cached query instances per query class\n");
        b.print("// -The sizes of retained child sets\n");
        b.print("// -List of parents for each query (search for 'P <query name>')\n");
        b.print("//  -Followed by status, where\n");
        b.print("//   -0=bound\n");
        b.print("//   -1=free\n");
        b.print("//   -2=unknown\n");
        b.print("//   -L=has listener\n");
        b.print("// -List of children for each query (search for 'C <query name>')\n");
        b.print("----------------------------------------\n");
        b.print("// Queries by class\n");
        for (Pair p : CollectionUtils.valueSortedEntries(counts)) {
            b.print(String.valueOf(-((Integer)p.second).intValue()) + " " + ((Class)p.first).getName() + "\n");
        }
        HashMap<CacheEntry, Integer> hist = new HashMap<CacheEntry, Integer>();
        for (CacheEntry e : workarea.keySet()) {
            hist.put(e, -1);
        }
        boolean changed = true;
        int iter = 0;
        while (changed && iter++ < 50) {
            changed = false;
            HashMap<CacheEntry, Integer> newHist = new HashMap<CacheEntry, Integer>();
            for (CacheEntry cacheEntry : workarea.keySet()) {
                newHist.put(cacheEntry, -1);
            }
            for (Map.Entry entry : workarea.entrySet()) {
                Integer c = (Integer)hist.get(entry.getKey());
                for (CacheEntry p : (Set)entry.getValue()) {
                    Integer i = (Integer)newHist.get(p);
                    newHist.put(p, i + c);
                }
            }
            for (CacheEntry cacheEntry : workarea.keySet()) {
                Integer old;
                Integer value = (Integer)newHist.get(cacheEntry);
                if (value.equals(old = (Integer)hist.get(cacheEntry))) continue;
                hist.put(cacheEntry, value);
                changed = true;
            }
            System.err.println("Retained set iteration " + iter);
        }
        b.print("// Queries by retained set\n");
        for (Pair p : CollectionUtils.valueSortedEntries(hist)) {
            b.print(-((Integer)p.second).intValue() + " " + p.first + "\n");
        }
        HashMap<CacheEntry, ArrayList<CacheEntry>> inverse = new HashMap<CacheEntry, ArrayList<CacheEntry>>();
        b.print("// Entry parent listing\n");
        for (CacheEntry cacheEntry : workarea.keySet()) {
            int status = (Integer)flagMap.get(cacheEntry);
            boolean hasListener = this.listening.hasListenerAfterDisposing(cacheEntry);
            b.print("Q " + cacheEntry.toString());
            if (hasListener) {
                b.print(" (L" + status + ")");
                ++listeners;
            } else {
                b.print(" (" + status + ")");
            }
            b.print("\n");
            for (CacheEntry parent : (Set)workarea.get(cacheEntry)) {
                ArrayList<CacheEntry> inv = (ArrayList<CacheEntry>)inverse.get(parent);
                if (inv == null) {
                    inv = new ArrayList<CacheEntry>();
                    inverse.put(parent, inv);
                }
                inv.add(cacheEntry);
                b.print("  " + parent.toString());
                b.print("\n");
            }
        }
        b.print("// Entry child listing\n");
        for (Map.Entry entry : inverse.entrySet()) {
            b.print("C " + ((CacheEntry)entry.getKey()).toString());
            b.print("\n");
            for (CacheEntry child : (Collection)entry.getValue()) {
                Integer h = (Integer)hist.get(child);
                if (h != null) {
                    b.print("  " + h);
                } else {
                    b.print("  <no children>");
                }
                b.print("  " + child.toString());
                b.print("\n");
            }
        }
        b.print("#queries: " + workarea.keySet().size() + "\n");
        b.print("#listeners: " + listeners + "\n");
        b.close();
        return "Dumped " + workarea.keySet().size() + " queries.";
    }

    boolean removeQuery(CacheEntry entry) {
        if (entry.isDiscarded()) {
            return false;
        }
        assert (!entry.isDiscarded());
        Query query = entry.getQuery();
        query.removeEntry(this);
        this.cache.updates = this.cache.updates + 1;
        this.cache.size = this.cache.size - 1;
        if ((entry.getGCStatus() & 1) != 0) {
            --this.boundQueries;
        }
        entry.discard();
        return true;
    }

    private boolean updateQuery(UpdateEntry e, LinkedList<UpdateEntry> todo, IdentityHashMap<CacheEntry, CacheEntry> immediates) throws DatabaseException {
        ArrayList entries;
        assert (e != null);
        CacheEntry entry = e.entry;
        if (entry.isDiscarded()) {
            return false;
        }
        if (entry.isExcepted()) {
            // empty if block
        }
        if (entry.isPending()) {
            // empty if block
        }
        this.cache.updates = this.cache.updates + 1;
        Query query = entry.getQuery();
        int type = query.type();
        boolean hasListener = this.listening.hasListener(entry);
        if (entry.isPending() || entry.isExcepted()) {
            if ((type & 1) == 1) {
                immediates.put(entry, entry);
            } else if (hasListener) {
                entry.refute();
            } else {
                this.removeQuery(entry);
            }
        } else if ((type & 1) == 1) {
            immediates.put(entry, entry);
        } else if (hasListener) {
            entry.refute();
        } else {
            this.removeQuery(entry);
        }
        if (hasListener && (entries = (ArrayList)this.listening.listeners.get((Object)entry)) != null) {
            for (ListenerEntry le : entries) {
                this.listening.scheduleListener(le);
            }
        }
        if (type == 0) {
            this.listening.updateParents(e.indent, entry, todo);
        }
        return hasListener;
    }

    private final boolean arrayEquals(Object av1, Object av2) {
        boolean p2;
        if (av2 == null) {
            return false;
        }
        Class<?> c1 = av1.getClass().getComponentType();
        Class<?> c2 = av2.getClass().getComponentType();
        if (c2 == null || !c1.equals(c2)) {
            return false;
        }
        boolean p1 = c1.isPrimitive();
        if (p1 != (p2 = c2.isPrimitive())) {
            return false;
        }
        if (!p1) {
            return Arrays.equals((Object[])av1, (Object[])av2);
        }
        if (Boolean.TYPE.equals(c1)) {
            return Arrays.equals((boolean[])av1, (boolean[])av2);
        }
        if (Byte.TYPE.equals(c1)) {
            return Arrays.equals((byte[])av1, (byte[])av2);
        }
        if (Integer.TYPE.equals(c1)) {
            return Arrays.equals((int[])av1, (int[])av2);
        }
        if (Long.TYPE.equals(c1)) {
            return Arrays.equals((long[])av1, (long[])av2);
        }
        if (Float.TYPE.equals(c1)) {
            return Arrays.equals((float[])av1, (float[])av2);
        }
        if (Double.TYPE.equals(c1)) {
            return Arrays.equals((double[])av1, (double[])av2);
        }
        throw new RuntimeException("??? Contact application querySupport.");
    }

    final Object compareTo(ReadGraphImpl graph, CacheEntry entry, Object oldValue) {
        try {
            Query query = entry.getQuery();
            entry.prepareRecompute(this.querySupport);
            ReadGraphImpl parentGraph = graph.forRecompute(entry);
            parentGraph.asyncBarrier.inc();
            query.recompute(parentGraph);
            parentGraph.asyncBarrier.dec();
            if (entry.isExcepted()) {
                return ListenerEntry.NO_VALUE;
            }
            Object newValue = entry.getResult();
            if (ListenerEntry.NO_VALUE == oldValue) {
                return newValue;
            }
            boolean changed = false;
            changed = newValue != null ? (newValue.getClass().isArray() ? !this.arrayEquals(newValue, oldValue) : !newValue.equals(oldValue)) : oldValue != null;
            return changed ? newValue : ListenerEntry.NOT_CHANGED;
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
            entry.except(t);
            return ListenerEntry.NO_VALUE;
        }
    }

    public boolean update(ReadGraphImpl graph, CacheEntry entry) {
        assert (!this.cache.collecting);
        assert (!this.updating);
        this.updating = true;
        boolean hadListeners = false;
        boolean listenersUnknown = false;
        try {
            assert (entry != null);
            LinkedList<UpdateEntry> todo = new LinkedList<UpdateEntry>();
            IdentityHashMap<CacheEntry, CacheEntry> immediates = new IdentityHashMap<CacheEntry, CacheEntry>();
            todo.add(new UpdateEntry(null, entry, 0));
            while (true) {
                if (!todo.isEmpty()) {
                    UpdateEntry e = (UpdateEntry)todo.pop();
                    hadListeners |= this.updateQuery(e, todo, immediates);
                    continue;
                }
                if (!immediates.isEmpty()) {
                    for (CacheEntry immediate : immediates.values()) {
                        if (immediate.isDiscarded()) continue;
                        if (immediate.isExcepted()) {
                            Object newValue = this.compareTo(graph, immediate, ListenerEntry.NO_VALUE);
                            if (newValue == ListenerEntry.NOT_CHANGED) continue;
                            this.listening.updateParents(0, immediate, todo);
                            continue;
                        }
                        Object oldValue = immediate.getResult();
                        Object newValue = this.compareTo(graph, immediate, oldValue);
                        if (newValue != ListenerEntry.NOT_CHANGED) {
                            this.listening.updateParents(0, immediate, todo);
                            continue;
                        }
                        immediate.setResult(oldValue);
                        immediate.setReady();
                        listenersUnknown = true;
                    }
                    immediates.clear();
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
        }
        assert (this.updating);
        this.updating = false;
        return hadListeners | listenersUnknown;
    }

    private void markForUpdate(ReadGraphImpl graph, CacheEntry e) {
        e.refute();
        this.refutations.add(e);
    }

    private void updateRefutations(ReadGraphImpl graph) {
        for (CacheEntry e : this.refutations) {
            this.update(graph, e);
        }
        this.refutations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateChangesInQueryCache(final ReadGraphImpl graph) {
        THashSet primitiveUpdates;
        this.listening.sync();
        this.cache.dirty = false;
        this.lastInvalidate = 0;
        if (this.scheduledObjectUpdates.size() == 1 && this.scheduledValueUpdates.size() == 0 && this.scheduledPrimitiveUpdates.size() == 0 && this.scheduledInvalidates.size() == 0) {
            OrderedSet os;
            DirectPredicates directPredicates;
            SuperRelations superRelations;
            long arg0 = this.scheduledObjectUpdates.getFirst();
            int subject = (int)(arg0 >>> 32);
            int predicate = (int)(arg0 & 0xFFFFFFFFFFFFFFFFL);
            for (Objects objects : QueryCache.entriesObjects(this, subject)) {
                this.markForUpdate(graph, objects);
            }
            for (DirectObjects directObjects : QueryCache.entriesDirectObjects(this, subject)) {
                this.markForUpdate(graph, directObjects);
            }
            for (Statements statements : QueryCache.entriesStatements(this, subject)) {
                this.markForUpdate(graph, statements);
            }
            if (predicate == this.instanceOf || predicate == this.inherits || predicate == this.subrelationOf) {
                Types types;
                PrincipalTypes principalTypes = QueryCache.entryPrincipalTypes(this, subject);
                if (principalTypes != null) {
                    this.markForUpdate(graph, principalTypes);
                }
                if ((types = QueryCache.entryTypes(this, subject)) != null) {
                    this.markForUpdate(graph, types);
                }
            }
            if (predicate == this.subrelationOf && (superRelations = SuperRelations.entry(this, subject)) != null) {
                this.markForUpdate(graph, superRelations);
            }
            if ((directPredicates = QueryCache.entryDirectPredicates(this, subject)) != null) {
                this.markForUpdate(graph, directPredicates);
            }
            if ((os = QueryCache.entryOrderedSet(this, predicate)) != null) {
                this.markForUpdate(graph, os);
            }
            this.updateRefutations(graph);
            this.scheduledObjectUpdates.clear();
            return;
        }
        if (this.scheduledObjectUpdates.size() == 0 && this.scheduledValueUpdates.size() == 1 && this.scheduledPrimitiveUpdates.size() == 0 && this.scheduledInvalidates.size() == 0) {
            int arg0 = this.scheduledValueUpdates.getFirst();
            ValueQuery valueQuery = QueryCache.entryValueQuery(this, arg0);
            if (valueQuery != null) {
                this.markForUpdate(graph, valueQuery);
            }
            this.updateRefutations(graph);
            this.scheduledValueUpdates.clear();
            return;
        }
        final TIntHashSet predicates = new TIntHashSet();
        final TIntHashSet orderedSets = new TIntHashSet();
        Object object = this.primitiveUpdateLock;
        synchronized (object) {
            primitiveUpdates = this.scheduledPrimitiveUpdates;
            this.scheduledPrimitiveUpdates = new THashSet();
        }
        this.scheduledValueUpdates.forEach(new TIntProcedure(){

            public boolean execute(int arg0) {
                ValueQuery valueQuery = QueryCache.entryValueQuery(QueryProcessor.this, arg0);
                if (valueQuery != null) {
                    QueryProcessor.this.markForUpdate(graph, valueQuery);
                }
                return true;
            }
        });
        this.scheduledInvalidates.forEach(new TIntProcedure(){

            public boolean execute(int resource) {
                SuperRelations superRelations;
                Types types;
                PrincipalTypes principalTypes;
                ValueQuery valueQuery = QueryCache.entryValueQuery(QueryProcessor.this, resource);
                if (valueQuery != null) {
                    QueryProcessor.this.markForUpdate(graph, valueQuery);
                }
                if ((principalTypes = QueryCache.entryPrincipalTypes(QueryProcessor.this, resource)) != null) {
                    QueryProcessor.this.markForUpdate(graph, principalTypes);
                }
                if ((types = QueryCache.entryTypes(QueryProcessor.this, resource)) != null) {
                    QueryProcessor.this.markForUpdate(graph, types);
                }
                if ((superRelations = SuperRelations.entry(QueryProcessor.this, resource)) != null) {
                    QueryProcessor.this.markForUpdate(graph, superRelations);
                }
                predicates.add(resource);
                return true;
            }
        });
        this.scheduledObjectUpdates.forEach(new TLongProcedure(){

            public boolean execute(long arg0) {
                SuperRelations superRelations;
                int subject = (int)(arg0 >>> 32);
                int predicate = (int)(arg0 & 0xFFFFFFFFFFFFFFFFL);
                if (predicate == QueryProcessor.this.instanceOf || predicate == QueryProcessor.this.inherits || predicate == QueryProcessor.this.subrelationOf) {
                    Types types;
                    PrincipalTypes principalTypes = QueryCache.entryPrincipalTypes(QueryProcessor.this, subject);
                    if (principalTypes != null) {
                        QueryProcessor.this.markForUpdate(graph, principalTypes);
                    }
                    if ((types = QueryCache.entryTypes(QueryProcessor.this, subject)) != null) {
                        QueryProcessor.this.markForUpdate(graph, types);
                    }
                }
                if (predicate == QueryProcessor.this.subrelationOf && (superRelations = SuperRelations.entry(QueryProcessor.this, subject)) != null) {
                    QueryProcessor.this.markForUpdate(graph, superRelations);
                }
                predicates.add(subject);
                orderedSets.add(predicate);
                return true;
            }
        });
        predicates.forEach(new TIntProcedure(){

            public boolean execute(int subject) {
                for (Objects objects : QueryCache.entriesObjects(QueryProcessor.this, subject)) {
                    QueryProcessor.this.markForUpdate(graph, objects);
                }
                for (DirectObjects directObjects : QueryCache.entriesDirectObjects(QueryProcessor.this, subject)) {
                    QueryProcessor.this.markForUpdate(graph, directObjects);
                }
                for (Statements statements : QueryCache.entriesStatements(QueryProcessor.this, subject)) {
                    QueryProcessor.this.markForUpdate(graph, statements);
                }
                DirectPredicates directPredicates = QueryCache.entryDirectPredicates(QueryProcessor.this, subject);
                if (directPredicates != null) {
                    QueryProcessor.this.markForUpdate(graph, directPredicates);
                }
                return true;
            }
        });
        orderedSets.forEach(new TIntProcedure(){

            public boolean execute(int orderedSet) {
                OrderedSet entry = QueryCache.entryOrderedSet(QueryProcessor.this, orderedSet);
                if (entry != null) {
                    QueryProcessor.this.markForUpdate(graph, entry);
                }
                return true;
            }
        });
        this.updateRefutations(graph);
        primitiveUpdates.forEach(new TObjectProcedure(){

            public boolean execute(Object arg0) {
                boolean listening;
                ExternalReadEntry query = (ExternalReadEntry)QueryProcessor.this.cache.externalReadEntryMap.get(arg0);
                if (query != null && !(listening = QueryProcessor.this.update(graph, query)) && !query.hasParents()) {
                    QueryProcessor.this.cache.externalReadEntryMap.remove(arg0);
                    query.discard();
                }
                return true;
            }
        });
        this.scheduledValueUpdates.clear();
        this.scheduledObjectUpdates.clear();
        this.scheduledInvalidates.clear();
    }

    public void updateValue(int resource) {
        this.scheduledValueUpdates.add(resource);
        this.cache.dirty = true;
    }

    public void updateStatements(int resource, int predicate) {
        this.scheduledObjectUpdates.add(((long)resource << 32) + (long)predicate);
        this.cache.dirty = true;
    }

    public void invalidateResource(int resource) {
        if (this.lastInvalidate == resource) {
            return;
        }
        this.scheduledValueUpdates.add(resource);
        this.lastInvalidate = resource;
        this.cache.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePrimitive(ExternalRead primitive) {
        Object object = this.primitiveUpdateLock;
        synchronized (object) {
            this.scheduledPrimitiveUpdates.add((Object)primitive);
        }
        this.querySupport.dirtyPrimitives();
    }

    public synchronized String toString() {
        return "QueryProvider [size = " + this.cache.size + ", hits = " + this.cache.hits + " misses = " + this.cache.misses + ", updates = " + this.cache.updates + "]";
    }

    protected void doDispose() {
        boolean alive;
        this.requests.release(0x3FFFFFFF);
        int index = 0;
        while (index < this.THREADS) {
            this.executors[index].dispose();
            ++index;
        }
        int i = 0;
        while (i < 100) {
            alive = false;
            int index2 = 0;
            while (index2 < this.THREADS) {
                alive |= this.executors[index2].isAlive();
                ++index2;
            }
            if (!alive) {
                return;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Logger.defaultLogError((Throwable)e);
            }
            ++i;
        }
        i = 0;
        while (i < 100) {
            alive = false;
            int index3 = 0;
            while (index3 < this.THREADS) {
                alive |= this.executors[index3].isAlive();
                ++index3;
            }
            if (!alive) {
                return;
            }
            index3 = 0;
            while (index3 < this.THREADS) {
                this.executors[index3].interrupt();
                ++index3;
            }
            ++i;
        }
        index = 0;
        while (index < this.THREADS) {
            try {
                this.executors[index].join(5000L);
            }
            catch (InterruptedException e) {
                Logger.defaultLogError((String)("QueryThread " + index + " will not die."), (Throwable)e);
            }
            this.executors[index] = null;
            ++index;
        }
    }

    public int getHits() {
        return this.cache.hits;
    }

    public int getMisses() {
        return this.cache.misses;
    }

    public int getSize() {
        return this.cache.size;
    }

    public Set<Long> getReferencedClusters() {
        CacheEntryBase query;
        HashSet<Long> result = new HashSet<Long>();
        for (CacheEntry cacheEntry : QueryCache.entriesObjects(this)) {
            query = (Objects)cacheEntry.getQuery();
            result.add(this.querySupport.getClusterId(query.r1()));
        }
        for (CacheEntry cacheEntry : QueryCache.entriesDirectPredicates(this)) {
            query = (DirectPredicates)cacheEntry.getQuery();
            result.add(this.querySupport.getClusterId(((DirectPredicates)query).id));
        }
        for (CacheEntry cacheEntry : this.cache.valueQueryMap.values()) {
            query = (ValueQuery)cacheEntry.getQuery();
            result.add(this.querySupport.getClusterId(((ValueQuery)query).id));
        }
        return result;
    }

    public void assertDone() {
    }

    CacheCollectionResult allCaches(CacheCollectionResult result) {
        return this.cache.allCaches(result);
    }

    public void printDiagnostics() {
    }

    public void requestCluster(ReadGraphImpl graph, long clusterId, Runnable runnable) {
        this.querySupport.requestCluster(graph, clusterId, runnable);
    }

    public int clean() {
        this.collector.collect(0, Integer.MAX_VALUE);
        return this.cache.size;
    }

    public void clean(final Collection<ExternalRead<?>> requests) {
        QueryCollectorSupport collectorSupport = new QueryCollectorSupport(){
            Iterator<ExternalRead<?>> iterator;
            {
                this.iterator = collection.iterator();
            }

            @Override
            public CacheCollectionResult allCaches() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CacheEntryBase iterate(int level) {
                if (this.iterator.hasNext()) {
                    ExternalRead<?> request = this.iterator.next();
                    ExternalReadEntry entry = (ExternalReadEntry)QueryProcessor.this.cache.externalReadEntryMap.get(request);
                    if (entry != null) {
                        return entry;
                    }
                    return this.iterate(level);
                }
                this.iterator = requests.iterator();
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setLevel(CacheEntryBase entry, int level) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<CacheEntry> getRootList() {
                ArrayList<CacheEntry> result = new ArrayList<CacheEntry>(requests.size());
                for (ExternalRead request : requests) {
                    ExternalReadEntry entry = (ExternalReadEntry)QueryProcessor.this.cache.externalReadEntryMap.get(request);
                    if (entry == null) continue;
                    result.add(entry);
                }
                return result;
            }

            @Override
            public int getCurrentSize() {
                return QueryProcessor.this.cache.size;
            }

            @Override
            public int calculateCurrentSize() {
                return Integer.MAX_VALUE;
            }

            @Override
            public boolean start(boolean flush) {
                return true;
            }
        };
        new QueryCollectorImpl2(this, collectorSupport).collect(0, Integer.MAX_VALUE);
    }

    public void scanPending() {
        this.cache.scanPending();
    }

    public ReadGraphImpl graphForVirtualRequest() {
        return ReadGraphImpl.createAsync(this);
    }

    public Class<?> getBuiltinValue(Resource r) {
        if (this.builtinValues == null) {
            this.initBuiltinValues();
        }
        return this.builtinValues.get(r);
    }

    private void initBuiltinValues() {
        Layer0 b = (Layer0)this.getSession().peekService(Layer0.class);
        if (b == null) {
            return;
        }
        this.builtinValues = new HashMap();
        this.builtinValues.put(b.String, String.class);
        this.builtinValues.put(b.Double, Double.class);
        this.builtinValues.put(b.Float, Float.class);
        this.builtinValues.put(b.Long, Long.class);
        this.builtinValues.put(b.Integer, Integer.class);
        this.builtinValues.put(b.Byte, Byte.class);
        this.builtinValues.put(b.Boolean, Boolean.class);
        this.builtinValues.put(b.StringArray, String[].class);
        this.builtinValues.put(b.DoubleArray, double[].class);
        this.builtinValues.put(b.FloatArray, float[].class);
        this.builtinValues.put(b.LongArray, long[].class);
        this.builtinValues.put(b.IntegerArray, int[].class);
        this.builtinValues.put(b.ByteArray, byte[].class);
        this.builtinValues.put(b.BooleanArray, boolean[].class);
    }

    @Override
    public final Session getSession() {
        return this.session;
    }

    public final ResourceSupport getResourceSupport() {
        return this.resourceSupport;
    }

    @Override
    public final void forEachPredicate(ReadGraphImpl impl, Resource subject, AsyncMultiProcedure<Resource> procedure) {
        try {
            Iterator<Resource> iterator = this.getPredicates(impl, subject).iterator();
            while (iterator.hasNext()) {
                Resource predicate = iterator.next();
                procedure.execute((AsyncReadGraph)impl, (Object)predicate);
            }
            procedure.finished((AsyncReadGraph)impl);
        }
        catch (Throwable e) {
            procedure.exception((AsyncReadGraph)impl, e);
        }
    }

    @Override
    public final void forEachPredicate(ReadGraphImpl impl, Resource subject, MultiProcedure<Resource> procedure) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final IntSet getPredicates(ReadGraphImpl impl, Resource subject) throws Throwable {
        return QueryCacheBase.resultPredicates(impl, this.querySupport.getId(subject), impl.parent, null);
    }

    @Override
    public final void forEachStatement(ReadGraphImpl impl, Resource subject, Resource predicate, final MultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            Statements.queryEach(impl, this.querySupport.getId(subject), this.querySupport.getId(predicate), this, impl.parent, listener, new TripleIntProcedureAdapter(){

                @Override
                public void execute(ReadGraphImpl graph, int s, int p, int o) {
                    try {
                        procedure.execute((Object)QueryProcessor.this.querySupport.getStatement(s, p, o));
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    try {
                        procedure.finished();
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception(t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forEachStatement(final ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncMultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        TripleIntProcedureAdapter proc = new TripleIntProcedureAdapter(){
            boolean first = true;

            @Override
            public void execute(ReadGraphImpl graph, int s, int p, int o) {
                try {
                    if (this.first) {
                        procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getStatement(s, p, o));
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)QueryProcessor.this.querySupport.getStatement(s, p, o));
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    if (this.first) {
                        this.first = false;
                        procedure.finished((AsyncReadGraph)graph);
                    } else {
                        procedure.finished((AsyncReadGraph)impl.newRestart(graph));
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first) {
                        this.first = false;
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        int pId = this.querySupport.getId(predicate);
        try {
            Statements.queryEach(impl, sId, pId, this, impl.parent, listener, proc);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forEachStatement(final ReadGraphImpl impl, Resource subject, Resource predicate, final StatementProcedure procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        TripleIntProcedureAdapter proc = new TripleIntProcedureAdapter(){
            boolean first = true;

            @Override
            public void execute(ReadGraphImpl graph, int s, int p, int o) {
                try {
                    if (this.first) {
                        procedure.execute((AsyncReadGraph)graph, s, p, o);
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), s, p, o);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    if (this.first) {
                        this.first = false;
                        procedure.finished((AsyncReadGraph)graph);
                    } else {
                        procedure.finished((AsyncReadGraph)impl.newRestart(graph));
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first) {
                        this.first = false;
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        int pId = this.querySupport.getId(predicate);
        try {
            Statements.queryEach(impl, sId, pId, this, impl.parent, listener, proc);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forStatementSet(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncSetListener<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachStatement(impl, subject, predicate, (AsyncMultiProcedure<Statement>)new AsyncMultiListener<Statement>(){
            private Set<Statement> current = null;
            private Set<Statement> run = new HashSet<Statement>();

            public void execute(AsyncReadGraph graph, Statement result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Statement r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Statement>();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }
        });
    }

    @Override
    public final void forEachAssertedStatement(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncMultiProcedure<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            QueryCache.runnerAssertedStatements(impl, this.querySupport.getId(subject), this.querySupport.getId(predicate), impl.parent, listener, new TripleIntProcedureAdapter(){

                @Override
                public void execute(ReadGraphImpl graph, int s, int p, int o) {
                    try {
                        procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getStatement(s, p, o));
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    try {
                        procedure.finished((AsyncReadGraph)graph);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    private static ListenerBase getListenerBase(Object procedure) {
        if (procedure instanceof ListenerBase) {
            return (ListenerBase)procedure;
        }
        return null;
    }

    @Override
    public final void forEachObject(ReadGraphImpl impl, Resource subject, Resource predicate, final MultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            QueryCache.runnerObjects(impl, this.querySupport.getId(subject), this.querySupport.getId(predicate), impl.parent, listener, new IntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    try {
                        procedure.execute((Object)QueryProcessor.this.querySupport.getResource(i));
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    try {
                        procedure.finished();
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    System.out.println("forEachObject exception " + t);
                    try {
                        procedure.exception(t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forEachDirectPredicate(ReadGraphImpl impl, Resource subject, final AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        int sId = this.querySupport.getId(subject);
        try {
            QueryCache.runnerDirectPredicates(impl, sId, impl.parent, listener, new InternalProcedure<IntSet>(){

                @Override
                public void execute(ReadGraphImpl graph, IntSet result) throws DatabaseException {
                    procedure.execute((AsyncReadGraph)graph, (Object)result);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
                    procedure.exception((AsyncReadGraph)graph, throwable);
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public final DirectStatements getDirectStatements(ReadGraphImpl impl, Resource subject, boolean ignoreVirtual) {
        return this.querySupport.getStatements(impl, this.querySupport.getId(subject), this, ignoreVirtual);
    }

    @Override
    public final void forPossibleObject(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncProcedure<Resource> procedure) {
        this.forEachObject(impl, subject, predicate, new AsyncMultiProcedure<Resource>(){
            private Resource single = null;

            public synchronized void execute(AsyncReadGraph graph, Resource result) {
                this.single = this.single == null ? result : INVALID_RESOURCE;
            }

            public synchronized void finished(AsyncReadGraph graph) {
                if (this.single == null || this.single == INVALID_RESOURCE) {
                    procedure.execute(graph, null);
                } else {
                    procedure.execute(graph, (Object)this.single);
                }
            }

            public synchronized void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    public final void forEachObject(ReadGraphImpl impl, Resource subject, Resource predicate, ListenerBase listener, IntProcedure procedure) {
        int sId = this.querySupport.getId(subject);
        int pId = this.querySupport.getId(predicate);
        try {
            QueryCache.runnerObjects(impl, sId, pId, impl.parent, listener, procedure);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public final int getSingleObject(ReadGraphImpl impl, Resource subject, Resource predicate) throws DatabaseException {
        int sId = this.querySupport.getId(subject);
        int pId = this.querySupport.getId(predicate);
        Runner2Procedure proc = new Runner2Procedure();
        QueryCache.runnerObjects(impl, sId, pId, impl.parent, null, proc);
        return proc.get();
    }

    @Override
    public final void forEachObject(final ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        if (impl.parent != null || listener != null) {
            IntProcedure ip = new IntProcedure(){
                AtomicBoolean first = new AtomicBoolean(true);

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    try {
                        if (this.first.get()) {
                            procedure.execute((AsyncReadGraph)impl, (Object)QueryProcessor.this.querySupport.getResource(i));
                        } else {
                            procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)QueryProcessor.this.querySupport.getResource(i));
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.finished((AsyncReadGraph)impl);
                        } else {
                            procedure.finished((AsyncReadGraph)impl.newRestart(graph));
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                public String toString() {
                    return "forEachObject with " + procedure;
                }
            };
            this.forEachObject(impl, subject, predicate, listener, ip);
        } else {
            IntProcedure ip = new IntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(i));
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    procedure.finished((AsyncReadGraph)graph);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    procedure.exception((AsyncReadGraph)graph, t);
                }

                public String toString() {
                    return "forEachObject with " + procedure;
                }
            };
            this.forEachObject(impl, subject, predicate, listener, ip);
        }
    }

    @Override
    public final void forObjectSet(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachObject(impl, subject, predicate, (AsyncMultiProcedure<Resource>)new AsyncMultiListener<Resource>(){
            private Set<Resource> current = null;
            private Set<Resource> run = new HashSet<Resource>();

            public void execute(AsyncReadGraph graph, Resource result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Resource r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Resource>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forObjectSet " + procedure;
            }
        });
    }

    @Override
    public final void forPredicateSet(ReadGraphImpl impl, Resource subject, final AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forEachPredicate(impl, subject, (AsyncMultiProcedure<Resource>)new AsyncMultiListener<Resource>(){
            private Set<Resource> current = null;
            private Set<Resource> run = new HashSet<Resource>();

            public void execute(AsyncReadGraph graph, Resource result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Resource r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Resource>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forPredicateSet " + procedure;
            }
        });
    }

    @Override
    public final void forPrincipalTypeSet(ReadGraphImpl impl, Resource subject, final AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        this.forEachPrincipalType(impl, subject, (AsyncMultiProcedure<Resource>)new AsyncMultiListener<Resource>(){
            private Set<Resource> current = null;
            private Set<Resource> run = new HashSet<Resource>();

            public void execute(AsyncReadGraph graph, Resource result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Resource r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Resource>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forPrincipalTypeSet " + procedure;
            }
        });
    }

    @Override
    public final void forAssertedObjectSet(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncSetListener<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachAssertedObject(impl, subject, predicate, (AsyncMultiProcedure<Resource>)new AsyncMultiListener<Resource>(){
            private Set<Resource> current = null;
            private Set<Resource> run = new HashSet<Resource>();

            public void execute(AsyncReadGraph graph, Resource result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Resource r : this.current) {
                        procedure.remove(graph, (Object)r);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Resource>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forObjectSet " + procedure;
            }
        });
    }

    @Override
    public final void forAssertedStatementSet(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncSetListener<Statement> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachAssertedStatement(impl, subject, predicate, (AsyncMultiProcedure<Statement>)new AsyncMultiListener<Statement>(){
            private Set<Statement> current = null;
            private Set<Statement> run = new HashSet<Statement>();

            public void execute(AsyncReadGraph graph, Statement result) {
                boolean found = false;
                if (this.current != null) {
                    found = this.current.remove(result);
                }
                if (!found) {
                    procedure.add(graph, (Object)result);
                }
                this.run.add(result);
            }

            public void finished(AsyncReadGraph graph) {
                if (this.current != null) {
                    for (Statement s : this.current) {
                        procedure.remove(graph, (Object)s);
                    }
                }
                this.current = this.run;
                this.run = new HashSet<Statement>();
            }

            public boolean isDisposed() {
                return procedure.isDisposed();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public String toString() {
                return "forStatementSet " + procedure;
            }
        });
    }

    @Override
    public final void forEachAssertedObject(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            QueryCache.runnerAssertedStatements(impl, this.querySupport.getId(subject), this.querySupport.getId(predicate), impl.parent, listener, new TripleIntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int s, int p, int o) {
                    try {
                        procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(o));
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    try {
                        procedure.finished((AsyncReadGraph)graph);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forEachPrincipalType(ReadGraphImpl impl, Resource subject, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        IntProcedure ip = new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(i));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished((AsyncReadGraph)graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        try {
            QueryCache.runnerPrincipalTypes(impl, sId, impl.parent, listener, ip);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forEachPrincipalType(ReadGraphImpl impl, Resource subject, final MultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            QueryCache.runnerPrincipalTypes(impl, this.querySupport.getId(subject), impl.parent, listener, new IntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    try {
                        procedure.execute((Object)QueryProcessor.this.querySupport.getResource(i));
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    try {
                        procedure.finished();
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception(t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forTypes(ReadGraphImpl impl, Resource subject, final AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        assert (listener == null);
        InternalProcedure<IntSet> ip = new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet set) {
                procedure.execute((AsyncReadGraph)graph, (Object)set);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                procedure.exception((AsyncReadGraph)graph, t);
            }
        };
        int sId = this.querySupport.getId(subject);
        try {
            QueryCache.runnerTypes(impl, sId, impl.parent, listener, ip);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final IntSet getTypes(ReadGraphImpl impl, Resource subject) throws Throwable {
        assert (subject != null);
        return QueryCacheBase.resultTypes(impl, this.querySupport.getId(subject), impl.parent, null);
    }

    @Override
    public final RelationInfo getRelationInfo(ReadGraphImpl impl, Resource subject) throws DatabaseException {
        assert (subject != null);
        return QueryCache.resultRelationInfoQuery(impl, this.querySupport.getId(subject), impl.parent, null);
    }

    @Override
    public final void forSupertypes(final ReadGraphImpl impl, Resource subject, final AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            QueryCache.runnerSuperTypes(impl, this.querySupport.getId(subject), impl.parent, listener, new InternalProcedure<IntSet>(){
                AtomicBoolean first = new AtomicBoolean(true);

                @Override
                public void execute(ReadGraphImpl graph, IntSet set) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.execute((AsyncReadGraph)graph, (Object)set);
                        } else {
                            procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)set);
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.exception((AsyncReadGraph)graph, t);
                        } else {
                            procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forDirectSuperrelations(ReadGraphImpl impl, Resource subject, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        IntProcedureAdapter ip = new IntProcedureAdapter(){

            @Override
            public void execute(ReadGraphImpl graph, int superRelation) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(superRelation));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                try {
                    procedure.finished((AsyncReadGraph)graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        try {
            QueryCache.runnerDirectSuperRelations(impl, sId, impl.parent, listener, ip);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forPossibleSuperrelation(ReadGraphImpl impl, Resource subject, AsyncProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        PossibleSuperRelation.queryEach(impl, this.querySupport.getId(subject), this, impl.parent, listener, procedure);
    }

    @Override
    public final void forSuperrelations(ReadGraphImpl impl, Resource subject, final AsyncProcedure<Set<Resource>> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        InternalProcedure<IntSet> ip = new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet set) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)set);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        int sId = this.querySupport.getId(subject);
        try {
            QueryCache.runnerSuperRelations(impl, sId, impl.parent, listener, ip);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final byte[] getValue(ReadGraphImpl impl, Resource subject) throws DatabaseException {
        return this.getValue(impl, this.querySupport.getId(subject));
    }

    public final byte[] getValue(ReadGraphImpl impl, int subject) throws DatabaseException {
        return QueryCache.resultValueQuery(impl, subject, impl.parent, null);
    }

    @Override
    public final void forValue(final ReadGraphImpl impl, Resource subject, final AsyncProcedure<byte[]> procedure) {
        assert (subject != null);
        assert (procedure != null);
        int sId = this.querySupport.getId(subject);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        InternalProcedure<byte[]> ip = new InternalProcedure<byte[]>(){
            AtomicBoolean first = new AtomicBoolean(true);

            @Override
            public void execute(ReadGraphImpl graph, byte[] result) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.execute((AsyncReadGraph)graph, (Object)result);
                    } else {
                        procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)result);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    if (this.first.compareAndSet(true, false)) {
                        procedure.exception((AsyncReadGraph)graph, t);
                    } else {
                        procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                    }
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        try {
            QueryCache.runnerValueQuery(impl, sId, impl.parent, listener, ip);
        }
        catch (DatabaseException databaseException) {
            throw new IllegalStateException("Internal error");
        }
    }

    @Override
    public final void forPossibleValue(final ReadGraphImpl impl, Resource subject, final AsyncProcedure<byte[]> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        if (impl.parent != null || listener != null) {
            InternalProcedure<byte[]> ip = new InternalProcedure<byte[]>(){
                AtomicBoolean first = new AtomicBoolean(true);

                @Override
                public void execute(ReadGraphImpl graph, byte[] result) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.execute((AsyncReadGraph)graph, (Object)result);
                        } else {
                            procedure.execute((AsyncReadGraph)impl.newRestart(graph), (Object)result);
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        if (this.first.compareAndSet(true, false)) {
                            procedure.exception((AsyncReadGraph)graph, t);
                        } else {
                            procedure.exception((AsyncReadGraph)impl.newRestart(graph), t);
                        }
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            };
            int sId = this.querySupport.getId(subject);
            try {
                QueryCache.runnerValueQuery(impl, sId, impl.parent, listener, ip);
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        } else {
            InternalProcedure<byte[]> ip = new InternalProcedure<byte[]>(){

                @Override
                public void execute(ReadGraphImpl graph, byte[] result) {
                    procedure.execute((AsyncReadGraph)graph, (Object)result);
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
            };
            int sId = this.querySupport.getId(subject);
            try {
                QueryCache.runnerValueQuery(impl, sId, impl.parent, listener, ip);
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }
    }

    @Override
    public final void forInverse(ReadGraphImpl impl, Resource relation, final AsyncProcedure<Resource> procedure) {
        assert (relation != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        IntProcedure ip = new IntProcedure(){
            private int result = 0;
            final AtomicBoolean found = new AtomicBoolean(false);
            final AtomicBoolean done = new AtomicBoolean(false);

            @Override
            public void finished(ReadGraphImpl graph) {
                if (this.done.compareAndSet(false, true)) {
                    try {
                        if (this.result == 0) {
                            procedure.exception((AsyncReadGraph)graph, (Throwable)new NoInverseException(""));
                        } else {
                            procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(this.result));
                        }
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                if (this.found.compareAndSet(false, true)) {
                    this.result = i;
                } else if (this.done.compareAndSet(false, true)) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)new ManyObjectsForFunctionalRelationException("Multiple items e.g. " + this.result + " and " + this.result));
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                if (this.done.compareAndSet(false, true)) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            }
        };
        int sId = this.querySupport.getId(relation);
        try {
            QueryCache.runnerObjects(impl, sId, this.getInverseOf(), impl.parent, listener, ip);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forResource(ReadGraphImpl impl, String id, final AsyncProcedure<Resource> procedure) {
        assert (id != null);
        assert (procedure != null);
        InternalProcedure<Integer> ip = new InternalProcedure<Integer>(){

            @Override
            public void execute(ReadGraphImpl graph, Integer result) {
                try {
                    procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(result));
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                try {
                    procedure.exception((AsyncReadGraph)graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        this.forResource(impl, id, impl.parent, ip);
    }

    @Override
    public final void forBuiltin(ReadGraphImpl impl, String id, final AsyncProcedure<Resource> procedure) {
        assert (id != null);
        assert (procedure != null);
        try {
            this.forBuiltin(impl, id, impl.parent, new InternalProcedure<Integer>(){

                @Override
                public void execute(ReadGraphImpl graph, Integer result) {
                    try {
                        procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(result));
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forHasStatement(ReadGraphImpl impl, Resource subject, AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            IntSet result = QueryCache.resultDirectPredicates(impl, this.querySupport.getId(subject), impl.parent, listener);
            procedure.execute((AsyncReadGraph)impl, (Object)(!result.isEmpty() ? 1 : 0));
        }
        catch (DatabaseException e) {
            procedure.exception((AsyncReadGraph)impl, (Throwable)e);
        }
    }

    @Override
    public final void forHasStatement(ReadGraphImpl impl, Resource subject, Resource predicate, final AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        AsyncMultiProcedureAdapter<Resource> ip = new AsyncMultiProcedureAdapter<Resource>(){
            boolean found = false;

            public synchronized void execute(AsyncReadGraph graph, Resource resource) {
                this.found = true;
            }

            public synchronized void finished(AsyncReadGraph graph) {
                try {
                    procedure.execute(graph, (Object)this.found);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        };
        this.forEachObject(impl, subject, predicate, (AsyncMultiProcedure<Resource>)ip);
    }

    @Override
    public final void forHasStatement(ReadGraphImpl impl, Resource subject, Resource predicate, final Resource object, final AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (predicate != null);
        assert (procedure != null);
        this.forEachObject(impl, subject, predicate, (AsyncMultiProcedure<Resource>)new AsyncMultiProcedureAdapter<Resource>(){
            boolean found = false;

            public synchronized void execute(AsyncReadGraph graph, Resource resource) {
                if (resource.equals(object)) {
                    this.found = true;
                }
            }

            public synchronized void finished(AsyncReadGraph graph) {
                try {
                    procedure.execute(graph, (Object)this.found);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public final void forHasValue(ReadGraphImpl impl, Resource subject, final AsyncProcedure<Boolean> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            QueryCache.runnerValueQuery(impl, this.querySupport.getId(subject), impl.parent, listener, new InternalProcedure<byte[]>(){

                @Override
                public void execute(ReadGraphImpl graph, byte[] object) {
                    boolean result = object != null;
                    try {
                        procedure.execute((AsyncReadGraph)graph, (Object)result);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final void forOrderedSet(ReadGraphImpl impl, Resource subject, final AsyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        assert (procedure != null);
        ListenerBase listener = QueryProcessor.getListenerBase(procedure);
        try {
            QueryCache.runnerOrderedSet(impl, this.querySupport.getId(subject), impl.parent, listener, new IntProcedure(){

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    try {
                        procedure.exception((AsyncReadGraph)graph, t);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    try {
                        procedure.execute((AsyncReadGraph)graph, (Object)QueryProcessor.this.querySupport.getResource(i));
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    try {
                        procedure.finished((AsyncReadGraph)graph);
                    }
                    catch (Throwable t2) {
                        Logger.defaultLogError((Throwable)t2);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    @Override
    public final <T> void query(ReadGraphImpl impl, MultiRead<T> request, CacheEntry parent, SyncMultiProcedure<T> procedure, ListenerBase listener) {
        assert (request != null);
        assert (procedure != null);
        try {
            this.queryMultiRead(impl, request, parent, listener, procedure);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final <T> void query(ReadGraphImpl impl, AsyncMultiRead<T> request, CacheEntry parent, final AsyncMultiProcedure<T> procedure, ListenerBase listener) {
        assert (request != null);
        assert (procedure != null);
        this.runAsyncMultiRead(impl, request, parent, listener, new AsyncMultiProcedure<T>(){

            public void execute(AsyncReadGraph graph, T result) {
                try {
                    procedure.execute(graph, result);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public void finished(AsyncReadGraph graph) {
                try {
                    procedure.finished(graph);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }

            public String toString() {
                return procedure.toString();
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                try {
                    procedure.exception(graph, t);
                }
                catch (Throwable t2) {
                    Logger.defaultLogError((Throwable)t2);
                }
            }
        });
    }

    @Override
    public VirtualGraph getProvider(Resource subject, Resource predicate, Resource object) {
        return this.querySupport.getProvider(this.querySupport.getId(subject), this.querySupport.getId(predicate), this.querySupport.getId(object));
    }

    @Override
    public VirtualGraph getProvider(Resource subject, Resource predicate) {
        return this.querySupport.getProvider(this.querySupport.getId(subject), this.querySupport.getId(predicate));
    }

    @Override
    public VirtualGraph getValueProvider(Resource subject) {
        return this.querySupport.getValueProvider(this.querySupport.getId(subject));
    }

    public boolean resumeTasks(ReadGraphImpl graph) {
        return this.querySupport.resume(graph);
    }

    public boolean isImmutable(int resourceId) {
        return this.querySupport.isImmutable(resourceId);
    }

    public boolean isImmutable(Resource resource) {
        ResourceImpl impl = (ResourceImpl)resource;
        return this.isImmutable(impl.id);
    }

    public Layer0 getL0(ReadGraph graph) {
        if (this.L0 == null) {
            this.L0 = Layer0.getInstance((ReadGraph)graph);
        }
        return this.L0;
    }

    public Layer0 getL0() {
        return this.L0;
    }

    public static interface AsyncBarrier {
        public void inc();

        public void dec();

        public void waitBarrier(Object var1, ReadGraphImpl var2);

        public boolean isBlocking();
    }

    static class Dummy
    implements InternalProcedure<Object>,
    IntProcedure {
        Dummy() {
        }

        @Override
        public void execute(ReadGraphImpl graph, int i) {
        }

        @Override
        public void finished(ReadGraphImpl graph) {
        }

        @Override
        public void execute(ReadGraphImpl graph, Object result) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    }

    static interface QueryCollector {
        public void collect(int var1, int var2);
    }

    static interface QueryCollectorSupport {
        public CacheCollectionResult allCaches();

        public Collection<CacheEntry> getRootList();

        public int getCurrentSize();

        public int calculateCurrentSize();

        public CacheEntryBase iterate(int var1);

        public void remove();

        public void setLevel(CacheEntryBase var1, int var2);

        public boolean start(boolean var1);
    }

    class QueryCollectorSupportImpl
    implements QueryCollectorSupport {
        private static final boolean DEBUG = false;
        private static final double ITERATION_RATIO = 0.2;
        private CacheCollectionResult iteration = new CacheCollectionResult();
        private boolean fresh = true;
        private boolean needDataInStart = true;

        QueryCollectorSupportImpl() {
            this.iteration.restart();
        }

        @Override
        public CacheCollectionResult allCaches() {
            CacheCollectionResult result = new CacheCollectionResult();
            QueryProcessor.this.allCaches(result);
            result.restart();
            return result;
        }

        @Override
        public boolean start(boolean flush) {
            this.fresh = true;
            if (this.needDataInStart || flush) {
                this.restart(flush ? 0.0 : 0.2);
            }
            return this.iteration.isAtStart();
        }

        private void restart(double targetRatio) {
            this.needDataInStart = true;
            long start = System.nanoTime();
            if (this.fresh) {
                boolean dirty;
                int iterationSize = this.iteration.size() + 1;
                int diff = this.calculateCurrentSize() - iterationSize;
                double ratio = (double)diff / (double)iterationSize;
                boolean bl = dirty = Math.abs(ratio) >= targetRatio;
                if (dirty) {
                    this.iteration = this.allCaches();
                } else {
                    this.iteration.restart();
                }
                this.fresh = false;
                this.needDataInStart = false;
            } else {
                this.iteration.restart();
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public CacheEntryBase iterate(int level) {
            entry = this.iteration.next(level);
            if (entry != null) ** GOTO lbl6
            this.restart(0.2);
            return null;
lbl-1000:
            // 1 sources

            {
                entry = this.iteration.next(level);
lbl6:
                // 2 sources

                ** while (entry != null && entry.isDiscarded())
            }
lbl7:
            // 1 sources

            return entry;
        }

        @Override
        public void remove() {
            this.iteration.remove();
        }

        @Override
        public void setLevel(CacheEntryBase entry, int level) {
            this.iteration.setLevel(entry, level);
        }

        @Override
        public Collection<CacheEntry> getRootList() {
            return QueryProcessor.this.cache.getRootList();
        }

        @Override
        public int calculateCurrentSize() {
            return QueryProcessor.this.cache.calculateCurrentSize();
        }

        @Override
        public int getCurrentSize() {
            return QueryProcessor.this.cache.size;
        }
    }

    static class Runner2Procedure
    implements IntProcedure {
        public int single = 0;
        public Throwable t = null;

        Runner2Procedure() {
        }

        public void clear() {
            this.single = 0;
            this.t = null;
        }

        @Override
        public void execute(ReadGraphImpl graph, int i) {
            this.single = this.single == 0 ? i : -1;
        }

        @Override
        public void finished(ReadGraphImpl graph) {
            if (this.single == -1) {
                this.single = 0;
            }
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
            this.single = 0;
            this.t = throwable;
        }

        public int get() throws DatabaseException {
            if (this.t != null) {
                if (this.t instanceof DatabaseException) {
                    throw (DatabaseException)this.t;
                }
                throw new DatabaseException(this.t);
            }
            return this.single;
        }
    }

    public static abstract class SessionRead
    extends SessionTask {
        public final Semaphore notify;
        public final DataContainer<Throwable> throwable;

        public SessionRead(DataContainer<Throwable> throwable, Semaphore notify) {
            super(null);
            this.throwable = throwable;
            this.notify = notify;
        }
    }

    public static abstract class SessionTask {
        protected final ReadGraphImpl rootGraph;
        private int counter = 0;
        protected int position = 1;
        private Exception trace;

        public SessionTask() {
            this(null);
        }

        public SessionTask(ReadGraphImpl rootGraph) {
            this.rootGraph = rootGraph;
        }

        public boolean isSubtask(ReadGraphImpl graph) {
            return graph.isParent(this.rootGraph);
        }

        public abstract void run0(int var1);

        public final void run(int thread) {
            if (this.counter++ > 0) {
                throw new IllegalStateException("Multiple invocations of SessionTask!");
            }
            this.run0(thread);
        }

        public boolean maybeReady() {
            return true;
        }

        public String toString() {
            if (this.rootGraph == null) {
                return "SessionTask[no graph]";
            }
            return "SessionTask[" + this.rootGraph.parent + "]";
        }
    }

    static enum ThreadState {
        INIT,
        RUN,
        SLEEP,
        DISPOSED;

    }
}

