/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.Arrays;

public final class IntArray {
    public static IntArray EMPTY = new IntArray();
    public int[] data = null;
    public int sizeOrData = -1;
    protected static final int DEFAULT_CAPACITY = 3;
    protected static final int NO_DATA = -1;

    public int size() {
        return this.data != null ? this.sizeOrData : (this.sizeOrData != -1 ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.sizeOrData == -1;
    }

    public void trim() {
        if (this.data != null) {
            int[] newData = new int[this.sizeOrData];
            System.arraycopy(this.data, 0, newData, 0, this.sizeOrData);
            this.data = newData;
        }
    }

    public void add(int val) {
        if (this.data == null) {
            if (this.sizeOrData == -1) {
                this.sizeOrData = val;
            } else {
                this.data = new int[3];
                this.data[0] = this.sizeOrData;
                this.data[1] = val;
                this.sizeOrData = 2;
            }
        } else if (this.data.length == this.sizeOrData) {
            int newCap = this.data.length << 1;
            int[] tmp = new int[newCap];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
            this.data[this.sizeOrData++] = val;
        } else {
            this.data[this.sizeOrData++] = val;
        }
    }

    int[] toArray() {
        int size = this.size();
        int[] result = new int[size];
        if (size == 1) {
            result[0] = this.sizeOrData;
        } else {
            System.arraycopy(this.data, 0, result, 0, size);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (IntArray.class != object.getClass()) {
            return false;
        }
        IntArray r = (IntArray)object;
        return this.sizeOrData == r.sizeOrData && Arrays.equals(this.data, r.data);
    }

    public String toString() {
        return "IntArray " + this.sizeOrData + " " + Arrays.toString(this.data);
    }
}

