/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.procedure;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.AsyncProcedure;

public class ResultCallWrappedSingleQueryProcedure4<Result>
implements AsyncProcedure<Result> {
    private final Object key;
    private Result result = null;
    private Throwable exception = null;
    private final AsyncProcedure<Result> procedure;
    private final AtomicBoolean latch;

    public ResultCallWrappedSingleQueryProcedure4(AsyncProcedure<Result> procedure, Object key) {
        assert (procedure != null);
        this.key = key;
        this.procedure = procedure;
        this.latch = new AtomicBoolean(false);
    }

    public void execute(AsyncReadGraph graph, Result result) {
        this.result = result;
        if (this.latch.compareAndSet(false, true)) {
            try {
                this.procedure.execute(graph, result);
            }
            catch (Throwable throwable) {
                Logger.defaultLogError((String)("AsyncProcedure.execute threw for " + this.procedure), (Throwable)throwable);
            }
        } else {
            Logger.defaultLogError((String)"Procedure was called many times (this time is execute)");
        }
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        this.exception = t;
        if (this.latch.compareAndSet(false, true)) {
            try {
                this.procedure.exception(graph, t);
            }
            catch (Throwable throwable) {
                Logger.defaultLogError((String)("AsyncProcedure.exception threw for " + this.procedure), (Throwable)throwable);
            }
        } else {
            Logger.defaultLogError((String)"Procedure was called many times (this time is exception)");
        }
    }

    public Result getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "." + this.procedure;
    }
}

