/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;

public abstract class CollectionUnaryQuery extends UnaryQuery<IntProcedure> implements IntProcedure {
    
    public CollectionUnaryQuery(final int id) {
        super(id);
    }
    
    public abstract void compute(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException;

    @Override
    public final void clearResult(QuerySupport support) {
    	setResult(new IntArray());
    }
    
    @Override
    public final void setReady() {
    	super.setReady();
    	IntArray v = (IntArray)getResult();
    	int size = v.size();
        if(size == 0) setResult(IntArray.EMPTY);
        else v.trim();
    }
    
    @Override
    public final Object performFromCache(ReadGraphImpl graph, final IntProcedure procedure) throws DatabaseException {

        assert(isReady());

        if(handleException(graph, procedure)) return EXCEPTED;
        
        final IntArray value = (IntArray)getResult();
        if(value.data == null) {
            if(value.sizeOrData != IntArray.NO_DATA) procedure.execute(graph, value.sizeOrData);
        } else {
            for(int i = 0;i < value.sizeOrData ; i++) procedure.execute(graph, value.data[i]);
        }

        procedure.finished(graph);
        
        return getResult();

    }

    @Override
    public final void recompute(ReadGraphImpl graph) throws DatabaseException {

        compute(graph, new IntProcedureAdapter() {

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                new Error("Error in recompute.", t).printStackTrace();
            }

        });

    }
    
    @Override
    final boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(id);
    }

    @Override
    public final void execute(ReadGraphImpl graph, int i) throws DatabaseException {
        IntArray v = (IntArray)getResult();
        v.add(i);
    }

    @Override
    public final void finished(ReadGraphImpl graph) throws DatabaseException {
        setReady();
    }

    @Override
    public final void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
        except(throwable);
    }

}
