package org.simantics.db.impl.graph;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.DevelopmentEvents.ClaimValueEvent;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;

public class ClaimValueEventImpl implements ClaimValueEvent {

	final private VirtualGraph virtualGraph;
	final private Resource subject;
	final private Object value;
	final private Binding binding;
	final private String text;
	
	public ClaimValueEventImpl(ReadGraph graph, VirtualGraph virtualGraph, Resource subject, Object value, Binding binding, String text) {
		this.virtualGraph = virtualGraph;
		this.subject = subject;
		this.value = value;
		this.binding = binding;
		this.text = text;
	}
	
	@Override
	public VirtualGraph getVirtualGraph() {
		return virtualGraph;
	}

	@Override
	public Resource getSubject() {
		return subject;
	}

	@Override
	public Object getValue() {
		return value;
	}

	@Override
	public Binding getBinding() {
		return binding;
	}
	
	@Override
	public String toString() {
		return text;
	}
	
}
