/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.exception;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.layer0.Layer0;

public class ManyObjectsForFunctionalRelationExceptionImpl extends ManyObjectsForFunctionalRelationException {

    private static final long serialVersionUID = 804263533707864050L;
    
    static String name(ReadGraphImpl graph, int subject) throws DatabaseException {
		Layer0 b = Layer0.getInstance(graph);
    	ResourceSupport support = graph.getService(ResourceSupport.class);
        Resource r = new ResourceImpl(support, subject);
        String name = graph.getPossibleRelatedValue(r, b.HasName, Bindings.STRING);
        return name;
    }
    
    public ManyObjectsForFunctionalRelationExceptionImpl(ReadGraphImpl graph, ManyObjectsForFunctionalRelationException source) throws DatabaseException {
        super("subject='" + name(graph, source.getIndex(0)) + "'");
    }

}
