/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import static org.junit.Assert.assertEquals;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.binary.BinaryMemory;

public class TestRandomValues {
		
	public @Test void doTest() throws Exception {
		VariantBinding b = (VariantBinding) Bindings.getMutableBinding( new VariantType() );
		for (int i=0; i<=10000; i++) {
			Object o = b.createRandomUnchecked(i);
			b.assertInstaceIsValid(o, null);
			
			Serializer s = Bindings.getSerializer( b );
			byte[] bytes = s.serialize(o);
			InputStream is = new ByteArrayInputStream(bytes);
			s.deserialize(is);
			assertEquals(0, is.available());
			
			Object o2 = b.createDefault();
			Binding cb = b.getContentBinding(o);
			b.setContent(o2, cb, cb.createDefault());
			s.deserializeTo(new BinaryMemory(bytes), o2);
			
			
			System.out.print(i+": ");
			System.out.println(b.printValueDefinition(o, true));
		}
	}
	
}

