package org.simantics.databoard.tests;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import junit.framework.Assert;

import org.junit.Test;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;

/**
 *
 * @author Toni Kalajainen <toni.kalajainen@iki.fi>
 */
public class TestMaliciousData {

	public @Test void testArray() throws Exception {
		
		
		Binding b = Bindings.getBinding(List.class, Integer.class);
		Serializer s = Bindings.getSerializer(b);

		// negative array length
		try {
			byte[] data = new byte[] {-1, -1, -1, -1, 0, 1, 2, 3, 4};
			s.deserialize(data);
			Assert.fail("Deserialization did not fail expectedly on negative length array");
		} catch (IOException e) {
			// Expected exception
		}

		// too big array
		try {
			byte[] data = new byte[] {10, 10, 10, 10, 0, 1, 2, 3, 4};
			s.deserialize(data);
			Assert.fail("Deserialization did not fail expectedly on too long array");
		} catch (IOException e) {
			// Expected exception
		}

		// OK Data
		try {
			byte[] data = new byte[] {0, 0, 0, 1, 0, 1, 2, 3};
			s.deserialize(data);
		} catch (IOException e) {
			Assert.fail("Deserialization did not work");
		}
		
	}
	
	public @Test void testBooleanArray() throws Exception {
		
		
		Binding b = Bindings.BOOLEAN_ARRAY;
		Serializer s = Bindings.getSerializer(b);

		// negative array length
		try {
			byte[] data = new byte[] {-1, -1, -1, -1, 0, 1, 2, 3, 4};
			s.deserialize(data);
			Assert.fail("Deserialization did not fail expectedly on negative length array");
		} catch (IOException e) {
			// Expected exception
		}

		// too big array
		try {
			byte[] data = new byte[] {10, 10, 10, 10, 0, 1, 2, 3, 4};
			s.deserialize(data);
			Assert.fail("Deserialization did not fail expectedly on too long array");
		} catch (IOException e) {
			// Expected exception
		}

		// OK Data
		try {
			byte[] data = new byte[] {0, 0, 0, 1, 1};
			s.deserialize(data);
		} catch (IOException e) {
			Assert.fail("Deserialization did not work");
		}
		
	}

	public @Test void testMap() throws Exception {
		
		
		Binding b = Bindings.getBinding(Map.class, Integer.class, Integer.class);
		Serializer s = Bindings.getSerializer(b);

		// negative array length
		try {
			byte[] data = new byte[] {-1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7};
			s.deserialize(data);
			Assert.fail("Deserialization did not fail expectedly on negative length array");
		} catch (IOException e) {
			// Expected exception
		}

		// too big array
		try {
			byte[] data = new byte[] {10, 10, 10, 10, 0, 1, 2, 3, 4};
			s.deserialize(data);
			Assert.fail("Deserialization did not fail expectedly on too long array");
		} catch (IOException e) {
			// Expected exception
		}

		// OK Data
		try {
			byte[] data = new byte[] {0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0};
			s.deserialize(data);
		} catch (IOException e) {
			Assert.fail("Deserialization did not work");
		}
		
	}
	
	
}
