/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import java.io.IOException;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.type.Datatype;

/**
 * In this example data type representation for a vector is created from 
 * a Java class.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class RepresentationExample2 {
	
	static class Vector {
		public Vector() {}
		int x, y, z;
	}
	
	public static void main(String[] args) throws SerializationException, IOException, BindingException {
        DataValueRepository vr = new DataValueRepository(); 		
		Datatype vectorDataType = Datatypes.getDatatypeUnchecked( Vector.class );
		System.out.println(vectorDataType);
		
		Bindings.getBindingUnchecked( Datatype.class ).printValue(vectorDataType, System.out, vr, true);		
	}

}

