/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.function;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.ui.ChartItemLabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.subscription.SubscriptionItemLabel;
import org.simantics.scl.reflection.annotations.SCLValue;

public class Labels {
    @SCLValue(type="ReadGraph -> Resource -> a -> String")
    public static String chartItemLabel(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Resource) {
            return ChartItemLabelRule.INSTANCE.getLabel_(graph, (Resource)context);
        }
        if (context instanceof Variable) {
            Variable var = (Variable)context;
            Resource r = var.getParent(graph).getPossibleRepresents(graph);
            if (r == null) {
                return "";
            }
            return ChartItemLabelRule.INSTANCE.getLabel_(graph, r);
        }
        throw new DatabaseException("Unknown context " + context);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> String")
    public static String chartItemSubscriptionInfo(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        String subscriptionLabel;
        Resource chartItem = null;
        if (context instanceof Resource) {
            chartItem = (Resource)context;
        } else if (context instanceof Variable) {
            Variable var = (Variable)context;
            chartItem = var.getParent(graph).getPossibleRepresents(graph);
        } else {
            throw new DatabaseException("Unknown context " + context);
        }
        if (chartItem == null) {
            return "";
        }
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        Resource subscriptionItem = graph.getPossibleObject(chartItem, CHART.Chart_Item_HasSubscriptionItem);
        if (subscriptionItem == null) {
            return "Not bound to a subscription item";
        }
        String itemLabel = SubscriptionItemLabel.resolveLabel((ReadGraph)graph, (Resource)subscriptionItem, null, (boolean)false, (boolean)false, (boolean)false);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource subscription = graph.getPossibleObject(subscriptionItem, L0.PartOf);
        if (subscription != null && (subscriptionLabel = (String)graph.getPossibleRelatedValue2(subscription, L0.HasLabel, (Binding)Bindings.STRING)) != null) {
            return String.valueOf(itemLabel) + " in subscription " + subscriptionLabel;
        }
        return itemLabel;
    }
}

