/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.simantics.Simantics;
import org.simantics.charts.editor.AddMilestoneDialog;
import org.simantics.charts.editor.EventData;
import org.simantics.charts.editor.TimeSeriesEditor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.ontology.EventViewResource;
import org.simantics.event.util.EventWriteData;
import org.simantics.event.view.handler.CorrectMilestoneLabelsAction;
import org.simantics.layer0.Layer0;
import org.simantics.trend.impl.TrendNode;

public class AddMilestoneHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TimeSeriesEditor tse = this.getTSE(event);
        if (tse == null) {
            return null;
        }
        TrendNode tn = tse.trendNode;
        if (tn == null) {
            return null;
        }
        Resource experiment = tse.chartData.run;
        if (experiment == null) {
            return null;
        }
        EventData data = new EventData();
        data.initialTime = tn.lastMouseHoverTime;
        AddMilestoneDialog d = new AddMilestoneDialog(tse.getSite().getShell(), data);
        int ok = d.open();
        if (ok != 0) {
            return null;
        }
        Session session = Simantics.getSession();
        VirtualGraph vg = ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent("experiments");
        session.async((WriteInterface)new CreateManualEvent(vg, experiment, data));
        return null;
    }

    TimeSeriesEditor getTSE(ExecutionEvent event) {
        Object eac = event.getApplicationContext();
        if (eac == null || !(eac instanceof IEvaluationContext)) {
            return null;
        }
        IEvaluationContext ec = (IEvaluationContext)eac;
        Object editor = ec.getVariable("activeEditor");
        if (editor == null || !(editor instanceof TimeSeriesEditor)) {
            return null;
        }
        TimeSeriesEditor tse = (TimeSeriesEditor)((Object)editor);
        return tse;
    }

    static class CreateManualEvent
    extends WriteRequest {
        private final Resource experiment;
        private final EventData eventData;

        public CreateManualEvent(VirtualGraph vg, Resource experiment, EventData eventData) {
            super(vg);
            this.experiment = experiment;
            this.eventData = eventData;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
            EventViewResource EVENTVIEW = EventViewResource.getInstance((ReadGraph)graph);
            Resource eventlog = graph.getPossibleObject(this.experiment, EVENT.IsEventProducerOf);
            if (eventlog == null) {
                return;
            }
            EventWriteData data = new EventWriteData((ReadGraph)graph, eventlog, this.getProvider());
            data.prepareToWrite((WriteOnlyGraph)graph);
            Resource event = graph.newResource();
            graph.claim(event, L0.InstanceOf, EVENT.Event);
            graph.claimLiteral(event, L0.HasName, L0.String, (Object)("" + data.targetPos), (Binding)Bindings.STRING);
            graph.claimLiteral(event, L0.HasLabel, L0.HasLabel_Inverse, L0.String, (Object)this.eventData.description, (Binding)Bindings.STRING);
            graph.claimLiteral(event, L0.HasDescription, L0.HasDescription_Inverse, L0.String, (Object)this.eventData.description, (Binding)Bindings.STRING);
            graph.claimLiteral(event, EVENT.HasTimestamp, EVENT.HasTimestamp_Inverse, EVENT.TimeStamp, (Object)this.eventData.parsedTime, (Binding)Bindings.DOUBLE);
            if (this.eventData.isMilestone) {
                graph.claim(event, EVENT.Milestone, event);
            }
            if (this.eventData.isBaseline) {
                graph.deny(eventlog, EVENT.EventLog_HasBaselineEvent);
                graph.claim(eventlog, EVENT.EventLog_HasBaselineEvent, event);
            }
            graph.claim(event, EVENT.Event_type, null, EVENTVIEW.ManualEventType);
            graph.claimLiteral(event, EVENT.Event_message, EVENT.Event_message_Inverse, L0.String, (Object)this.eventData.message, (Binding)Bindings.STRING);
            graph.claimLiteral(event, EVENT.Event_tag, EVENT.Event_tag_Inverse, L0.String, (Object)this.eventData.tag, (Binding)Bindings.STRING);
            graph.claim(event, EVENT.NoReturn, EVENT.NoReturn, event);
            graph.claim(data.targetSlice, L0.ConsistsOf, L0.PartOf, event);
            data.written();
            data.commit((WriteOnlyGraph)graph);
            graph.syncRequest((Write)new CorrectMilestoneLabelsAction(eventlog, this.getProvider()));
        }
    }
}

