/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - issue #4262
 *******************************************************************************/
package org.simantics.charts.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.preference.ChartPreferences;
import org.simantics.charts.preference.ChartTimeWindowTemplate;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.trend.configuration.YAxisMode;

/**
 * @author Tuukka Lehtonen
 */
public class NewChart implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                try {
                    createChart(parent);
                } catch (DatabaseException e) {
                    Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to create chart.", e));
                }
            }
        };
    }

    public static Resource createChart (final Resource target) throws DatabaseException {

        return Simantics.getSession().syncRequest(new WriteResultRequest<Resource>() {
        	@Override
            public Resource perform(WriteGraph g) throws DatabaseException {
        	    g.markUndoPoint();
                Layer0 l0 = Layer0.getInstance(g);
                Layer0X L0X = Layer0X.getInstance(g);
                ChartResource wr = ChartResource.getInstance(g);
                String freshName = NameUtils.findFreshName(g, "Chart", target);
                Resource chart = g.newResource();
                g.claim(chart, l0.InstanceOf, null, wr.TimeSeriesChart);
                g.claimLiteral(chart, l0.HasName, freshName, Bindings.STRING);
                g.claim(chart, l0.PartOf, target);

                IEclipsePreferences pn = InstanceScope.INSTANCE.getNode( "org.simantics.charts" );

                // Template
                {
                    String templateId = pn.get(ChartPreferences.P_TIMEWINDOW_TEMPLATE, ChartPreferences.DEFAULT_TIMEWINDOW_TEMPLATE);
                    ChartTimeWindowTemplate template = ChartTimeWindowTemplate.getTemplate( templateId );
                    if (template != null) {
                        Resource r = g.getResource( template.uri );
                        g.claim(chart, L0X.ObtainsProperty1, null, r);
                    }
                }

                // Axis Mode
                {
                    String sam = pn.get(ChartPreferences.P_AXISMODE, ChartPreferences.DEFAULT_AXISMODE);
                    YAxisMode am = YAxisMode.valueOf( sam );
                    Resource ram = null;
                    if ( am == YAxisMode.SingleAxis ) ram = wr.YAxisMode_SingleAxis;
                    if ( am == YAxisMode.MultiAxis ) ram = wr.YAxisMode_MultiAxis;
                    if ( ram != null ) {
                        g.claim(chart, wr.Chart_YAxisMode, ram);
                    }
                }
                
                CommentMetadata cm = g.getMetadata(CommentMetadata.class);
                g.addMetadata(cm.add("Created new chart named " + freshName + ", resource " + chart));
                
                return chart;
            }
        });
    }

}
