/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.management.ISessionContext;
import org.simantics.history.csv.ColumnSeparator;
import org.simantics.history.csv.DecimalSeparator;
import org.simantics.history.csv.ExportInterpolation;
import org.simantics.project.IProject;

/**
 * @author Antti Villberg
 */
public class CSVExportPlan {
	
    // Input
    ISessionContext sessionContext;
    IProject        project;
    Object          selection;
    Deque<String>   recentLocations;

    // Output
    Collection<Resource> items = new HashSet<>();
    File                 exportLocation;

    
    public double				startTime;
    public double				timeStep;
    public DecimalSeparator	decimalSeparator;
    public ColumnSeparator		columnSeparator;
    public boolean             resample;
    public ExportInterpolation samplingMode;
    public int					timeDigits;
    public int					floatDigits;
    public int					doubleDigits;


    /**
     * <code>true</code> if the model should be overwritten without a warning.
     */
    boolean         overwrite;

    /**
     * Constructor for SCL support
     */
    public CSVExportPlan(double startTime, double timeStep, DecimalSeparator dsep, ColumnSeparator csep, boolean resample, ExportInterpolation mode, int timeDigits, int floatDigits, int doubleDigits) {
        this.sessionContext = Simantics.getSessionContext();
        this.recentLocations = new ArrayDeque<>();
        
        this.startTime = startTime;
        this.timeStep = timeStep;
        this.decimalSeparator = dsep;
        this.columnSeparator = csep;
        this.resample = resample;
        this.samplingMode = mode;
        this.timeDigits = timeDigits;
        this.floatDigits = floatDigits;
        this.doubleDigits = doubleDigits;
    }

    public void setItems(List<Resource> items) {
        this.items = items;
    }

    CSVExportPlan(ISessionContext sessionContext, Deque<String> recentLocations) {
        this.sessionContext = sessionContext;
        this.recentLocations = recentLocations;
    }

}