/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.query;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.handler.MilestoneList;
import org.simantics.event.view.handler.MilestoneListQuery;
import org.simantics.layer0.Layer0;
import org.simantics.trend.impl.Milestone;
import org.simantics.trend.impl.MilestoneSpec;

public class MilestoneSpecQuery extends ResourceRead<MilestoneSpec> {
	
	public MilestoneSpecQuery(Resource eventlog) {
		super(eventlog);
	}
	
    @Override
    public MilestoneSpec perform(ReadGraph graph) throws DatabaseException {
    	MilestoneSpec result = new MilestoneSpec();
    	result.init();
    	result.baseline = -1;
    	Layer0 L0 = Layer0.getInstance(graph);
        EventResource EVENT = EventResource.getInstance(graph);

        Resource experiment = resource;
        Resource eventLog = graph.getPossibleObject(experiment, EVENT.IsEventProducerOf);        
        if (eventLog != null) {
        	MilestoneList ml = graph.sync( new MilestoneListQuery(eventLog) );
        	for (Resource event : ml.milestones) 
        	{        		
        		boolean isMilestone = graph.hasStatement(event, EVENT.Milestone);
        		boolean isHidden = graph.hasStatement(event, EVENT.Hidden);
        		boolean isBaseline = event.equals(ml.baseline);
        		if (!isMilestone && !isBaseline) continue;

        		Double creationTime = graph.getPossibleRelatedValue(event, EVENT.HasTimestamp);
        		String milestoneLabel = graph.getPossibleRelatedValue(event, EVENT.Event_milestoneLabel);
        		String label = graph.getPossibleRelatedValue(event, L0.HasLabel);  
        		
        		Milestone ms = new Milestone();
        		ms.label = milestoneLabel==null ? "" : milestoneLabel;
        		ms.description = label==null ? "" : label;
        		ms.id = graph.getRelatedValue(event, L0.HasName);
        		ms.time = creationTime==null ? 0.0 : creationTime;
        		ms.hidden = isHidden;
        		if (isBaseline) result.baseline = result.milestones.size(); 
        		result.milestones.add( ms );
        	}
        }
        
        return result;
    }

	public Resource getEventLog() {
		return resource;
	}	


}
