package org.simantics.charts.editor;

import org.eclipse.jface.action.Action;
import org.simantics.db.Resource;
import org.simantics.trend.impl.TrendNode;

/**
 * @author Tuukka Lehtonen
 */
public class MoveHairlineAction extends Action {

    private final Resource chart;
    private final TrendNode trend;
    private final double time;
    private final Boolean setTrackExperimentTime;

    public MoveHairlineAction(String name, Resource chart, boolean enabled, TrendNode trend, double time) {
        this(name, chart, enabled, trend, time, null);
    }

    public MoveHairlineAction(String name, Resource chart, boolean enabled, TrendNode trend, double time, Boolean setTrackExperimentTime) {
        super(name);
        setEnabled(enabled);
        this.chart = chart;
        this.trend = trend;
        this.time = time;
        this.setTrackExperimentTime = setTrackExperimentTime;
    }

    @Override
    public void run() {
        trend.valueTipTime = time;
        trend.repaint();
        if (setTrackExperimentTime != null) {
            TrackExperimentTimeAction.setTracking(chart, setTrackExperimentTime);
        }
    }

}