/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledAction;
import org.simantics.browsing.ui.swt.ModelledControl;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;

public class ModelledDialog
implements ModelledAction {
    final Resource configuration;

    public ModelledDialog(Resource configuration) {
        this.configuration = configuration;
    }

    @Override
    public Runnable create(IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {
        final String title = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                return (String)graph.getPossibleRelatedValue(ModelledDialog.this.configuration, br.Dialog_Title, (Binding)Bindings.STRING);
            }
        });
        return new Runnable(){

            @Override
            public void run() {
                DialogImpl dialog = new DialogImpl(Display.getCurrent().getActiveShell(), support, title);
                dialog.create();
                support.update();
                dialog.open();
            }
        };
    }

    public class DialogImpl
    extends Dialog {
        private final WidgetSupport widgetSupport;
        private Runnable finishAction;
        private final String title;

        public DialogImpl(Shell shell, WidgetSupport support, String title) {
            super(shell);
            this.title = title;
            this.widgetSupport = support;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.title != null) {
                shell.setText(this.title);
            }
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            if (this.finishAction != null) {
                this.finishAction.run();
            }
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            try {
                ModelledControl modelledControl = (ModelledControl)Simantics.getSession().syncRequest((Read)new Read<ModelledControl>(){

                    public ModelledControl perform(ReadGraph graph) throws DatabaseException {
                        BrowsingResource BRO = BrowsingResource.getInstance((ReadGraph)graph);
                        Resource controlResource = graph.getPossibleObject(((DialogImpl)DialogImpl.this).ModelledDialog.this.configuration, BRO.Dialog_Control);
                        return (ModelledControl)graph.adapt(controlResource, ModelledControl.class);
                    }
                });
                ModelledAction finishAction = (ModelledAction)Simantics.getSession().syncRequest((Read)new Read<ModelledAction>(){

                    public ModelledAction perform(ReadGraph graph) throws DatabaseException {
                        BrowsingResource BRO = BrowsingResource.getInstance((ReadGraph)graph);
                        Resource actionResource = graph.getPossibleObject(((DialogImpl)DialogImpl.this).ModelledDialog.this.configuration, BRO.Dialog_FinishAction);
                        return (ModelledAction)graph.adapt(actionResource, ModelledAction.class);
                    }
                });
                this.finishAction = finishAction.create(null, null, this.widgetSupport);
                return modelledControl.create(composite, null, null, this.widgetSupport);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return composite;
            }
        }

        protected Control createContents(Composite parent) {
            return super.createContents(parent);
        }
    }
}

