/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;

public class CCombo2 extends WidgetImpl {

    private final CopyOnWriteArrayList<SelectionListener> selectionListeners = new CopyOnWriteArrayList<SelectionListener>();
    private List<Pair<String, Object>> itemList;

    final private Display display;
    final private org.eclipse.swt.custom.CCombo combo;

    public CCombo2(Composite parent, WidgetSupport support, int style) {
    	super(support);
        this.display = parent.getDisplay();
        combo = new org.eclipse.swt.custom.CCombo(parent, style);
        combo.setData("org.simantics.browsing.ui.widgets.Combo", this);
        support.register(this);
    }

    public <T> void setAvailable(final ParametrizedRead<T, List<Pair<String, Object>>> read) {
    	
    	Simantics.getSession().async(new UniqueRead<List<Pair<String, Object>>>() {

			@Override
			public List<Pair<String, Object>> perform(ReadGraph graph) throws DatabaseException {
				T input = support.getInput(graph);
				System.err.println("read: " + read);
				return graph.syncRequest(read.get(input));
			}
    		
    	}, new Listener<List<Pair<String, Object>>>() {

            @Override
            public void exception(Throwable t) {
                t.printStackTrace();
            }

            @Override
            public void execute(final List<Pair<String, Object>> items) {
                if(isDisposed()) return;
                display.asyncExec(new Runnable() {

                    @Override
                    public void run() {
                        if(isDisposed()) return;
                        itemList = items;
                        for(SelectionListener listener : selectionListeners) combo.removeSelectionListener(listener);
                        combo.setData(items);
                        combo.clearSelection();
                        try {
                            combo.removeAll();
                        } catch (Throwable t) {
                            t.printStackTrace();
                        }
                        if (items != null) {
                            int index = 0;
                            for(Pair<String, Object> key : items) {
                                combo.add(key.first);
                                combo.setData(key.first, index++);
                            }
                            String selectionKey = (String)combo.getData("_SelectionKey");
                            if(selectionKey != null) {
                                Integer selectionIndex = (Integer)combo.getData(selectionKey);
                                if(selectionIndex != null) combo.select(selectionIndex);
                            }
                        }
                        for(SelectionListener listener : selectionListeners) combo.addSelectionListener(listener);
                    }

                });
            }

            @Override
            public boolean isDisposed() {
                return combo.isDisposed();
            }

        });
    	
    }

    public <T> void setSelection(final ParametrizedRead<T, String> read) {
    	
    	Simantics.getSession().async(new UniqueRead<String>() {

			@Override
			public String perform(ReadGraph graph) throws DatabaseException {
				T input = support.getInput(graph);
				System.err.println("read: " + read);
				return graph.syncRequest(read.get(input));
			}
    		
    	}, new Listener<String>() {

            @Override
            public void exception(Throwable t) {
                t.printStackTrace();
            }

            @Override
            public void execute(final String selectionKey) {
                if(isDisposed()) return;
                display.asyncExec(new Runnable() {

                    @Override
                    public void run() {
                        if(isDisposed()) return;
                        if(selectionKey == null) return;
                        for(SelectionListener listener : selectionListeners) combo.removeSelectionListener(listener);
                        combo.setData("_SelectionKey", selectionKey);
                        Integer selectionIndex = (Integer)combo.getData(selectionKey);
                        if(selectionIndex != null) combo.select(selectionIndex);
                        for(SelectionListener listener : selectionListeners) combo.addSelectionListener(listener);
                    }

                });
            }

            @Override
            public boolean isDisposed() {
            	return combo.isDisposed();
            }

        });
    	
    }

    public org.eclipse.swt.custom.CCombo getWidget() {
        return combo;
    }

    @Override
    public Control getControl() {
        return combo;
    }

    @Override
    public void setInput(ISessionContext context, Object input) {

        if (selectionListeners != null) {
            for (SelectionListener listener : selectionListeners) {
                if(listener instanceof Widget) {
                    ((Widget) listener).setInput(context, input);
                }
            }
        }

    }

    public synchronized void addSelectionListener(SelectionListener listener) {
        selectionListeners.add(listener);
        combo.addSelectionListener(listener);
    }

    /**
     * @param index
     * @return
     * @throws IndexOutOfBoundsException if index is outside widget bounds
     */
    @SuppressWarnings("unchecked")
    public <T> Pair<String, T> getData(int index) {
        if (index == -1)
            return null;
        return (Pair<String, T>) itemList.get(index);
    }

    /**
     * @return selected combo list item or <code>null</code> if no item is
     *         selected
     */
    public <T> Pair<String, T> getSelectedData() {
        return getData(combo.getSelectionIndex());
    }

}
