/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.browsing.ui.graph.impl.LazyViewpoint;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class ValuePropertyViewpointFactory implements ViewpointFactory {

    @Override
    public Viewpoint create(PrimitiveQueryUpdater provider, final NodeContext context, ViewpointKey key) {
        assert(provider != null);
        assert(context != null);

        return new LazyViewpoint(provider, context, key) {
            @Override
            public NodeContext[] children(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance(graph);
                ResourceArray ra = ResourceAdaptionUtils.toSingleResourceArray(context.getConstant(BuiltinKeys.INPUT));
                Collection<Resource> children = graph.getObjects(ra.resources[0], L0.HasProperty);

                ArrayList<NodeContext> resultContexts = new ArrayList<NodeContext>();
                for (Resource child : children) {
                    if (graph.isInstanceOf(child, L0.Literal)) {
                        resultContexts.add(NodeContextBuilder.buildWithInput(child));
                    }
                }

                return resultContexts.toArray(new NodeContext[resultContexts.size()]);
            }

            @Override
            public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
                return children(graph).length > 0;
            }
        };
    }

    @Override
    public String toString() {
        return "Scalar values";
    }

}
