/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.Set;

import org.eclipse.jface.resource.FontDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.PrunedChildrenResult;

/**
 * A label decorator factory that shows a [children shown/total] suffix for a
 * node context when it is expanded.
 * 
 * @author Tuukka Lehtonen
 */
public class TreeTruncationDecoratorFactory {

    protected int         withStyle;
    protected Set<String> decoratedColumns;

    public TreeTruncationDecoratorFactory(int withStyle) {
        this(withStyle, Collections.singleton(ColumnKeys.SINGLE));
    }

    public TreeTruncationDecoratorFactory(int withStyle, Set<String> decoratedColumns) {
        this.withStyle = withStyle;
        this.decoratedColumns = decoratedColumns;
    }

    public LabelDecorator create(NodeQueryManager manager, NodeContext context) {
        boolean expanded = manager.query(context, BuiltinKeys.IS_EXPANDED);
        if (!expanded)
            return null;

        PrunedChildrenResult prunedChildren = manager.query(context, BuiltinKeys.PRUNED_CHILDREN);
        NodeContext[] finalChildren = manager.query(context, BuiltinKeys.FINAL_CHILDREN);
        final int prunedLength = prunedChildren.getPrunedChildren().length;
        final int finalLength = finalChildren.length;
        if (prunedLength == finalLength) {
            if (finalLength >= 10) {
                return new LabelDecorator.Stub() {
                    @Override
                    public String decorateLabel(String label, String column, int itemIndex) {
                        if (decoratedColumns.contains(column))
                            return label + " [" + finalLength + "]";
                        return null;
                    }
                    @Override
                    public <F> F decorateFont(F font, String column, int itemIndex) {
                        //if (decoratedColumns.contains(column))
                        //    return (F) ((FontDescriptor) font).withStyle(withStyle);
                        return null;
                    }
                };
            }
            return null;
        }

        return new LabelDecorator.Stub() {
            @Override
            public String decorateLabel(String label, String column, int itemIndex) {
                if (decoratedColumns.contains(column))
                    return label + " [showing " + finalLength + "/" + prunedLength + "]";
                return null;
            }
            @SuppressWarnings("unchecked")
            @Override
            public <F> F decorateFont(F font, String column, int itemIndex) {
                if (decoratedColumns.contains(column))
                    return (F) ((FontDescriptor) font).withStyle(withStyle);
                return null;
            }
        };
    }

}