/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.processors.FilterSelectionRequestQueryProcessor;

/**
 * A FilterArea variant that always filters the explorer root node instead of
 * the currently selected one.
 * 
 * @author Tuukka Lehtonen
 */
public class RootFilterArea extends FilterArea {

    /**
     * Construct the filter area UI component.
     * 
     * @param explorer
     * @param queryProcessor
     * @param parent
     * @param style
     */
    public RootFilterArea(final GraphExplorer explorer, final FilterSelectionRequestQueryProcessor queryProcessor, Composite parent, int style) {
        super(explorer, queryProcessor, parent, style);
    }

    @Override
    protected void addExplorerSelectionListener() {
        // Intentional NOP.
    }

    @Override
    protected NodeContext getFilteredNode() {
        return explorer.getRoot();
    }

}
