/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ImageDecoratorKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.content.ImageDecoratorFactory;

public class DefaultImageDecoratorsProcessor extends AbstractNodeQueryProcessor<Collection<ImageDecorator>> {

    @Override
    public Collection<ImageDecorator> query(NodeQueryManager manager, NodeContext context) {
        Collection<ImageDecoratorFactory> factories = manager.query(context, BuiltinKeys.SELECTED_IMAGE_DECORATOR_FACTORIES);
        if (factories.isEmpty())
            return Collections.emptyList();

        Collection<ImageDecorator> decorators = new ArrayList<ImageDecorator>(factories.size());
        for (ImageDecoratorFactory f : factories) {
            assert f != null;
            ImageDecorator decorator = manager.query(context, new ImageDecoratorKey(f));
            if (decorator != null)
                decorators.add(decorator);
        }

        return decorators;
    }

    @Override
    public String toString() {
        return "ImageDecoratorsProcessor";
    }

    @Override
    public QueryKey<Collection<ImageDecorator>> getIdentifier() {
        return BuiltinKeys.IMAGE_DECORATORS;
    }

}
