/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class GEIconPainter
extends BackgroundPainter {
    protected boolean calculateByWidth;
    protected boolean calculateByHeight;

    public GEIconPainter(ICellPainter painter) {
        super(painter);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().width;
        }
        return 0;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().height;
        }
        return 0;
    }

    public ICellPainter getCellPainterAt(int x, int y, ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
            int x0 = bounds.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width);
            int y0 = bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height);
            if (x >= x0 && x < x0 + imageBounds.width && y >= y0 && y < y0 + imageBounds.height) {
                return super.getCellPainterAt(x, y, cell, gc, bounds, configRegistry);
            }
        }
        return null;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
            int contentHeight = imageBounds.height;
            if (this.calculateByHeight && contentHeight > bounds.height) {
                int contentToCellDiff = cell.getBounds().height - bounds.height;
                ILayer layer = cell.getLayer();
                layer.doCommand((ILayerCommand)new RowResizeCommand(layer, cell.getRowPosition(), contentHeight + contentToCellDiff));
            }
            int contentWidth = imageBounds.width;
            if (this.calculateByWidth && contentWidth > bounds.width) {
                int contentToCellDiff = cell.getBounds().width - bounds.width;
                ILayer layer = cell.getLayer();
                layer.doCommand((ILayerCommand)new ColumnResizeCommand(layer, cell.getColumnPosition(), contentWidth + contentToCellDiff));
            }
            int px = CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.width);
            int py = CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height);
            Rectangle b = new Rectangle(bounds.x + px + imageBounds.width, bounds.y, bounds.width - px - imageBounds.width, bounds.height);
            super.paintCell(cell, gc, b, configRegistry);
            gc.drawImage(image, bounds.x + px, bounds.y + py);
        } else {
            super.paintCell(cell, gc, bounds, configRegistry);
        }
    }

    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return (Image)CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry).getAttributeValue(CellStyleAttributes.IMAGE);
    }

    public boolean isCalculateByWidth() {
        return this.calculateByWidth;
    }

    public void setCalculateByWidth(boolean calculateByWidth) {
        this.calculateByWidth = calculateByWidth;
    }

    public boolean isCalculateByHeight() {
        return this.calculateByHeight;
    }

    public void setCalculateByHeight(boolean calculateByHeight) {
        this.calculateByHeight = calculateByHeight;
    }
}

