/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.nodetypes;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.viewpoint.ontology.ViewpointResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialNodeType
implements NodeType {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecialNodeType.class);
    public Resource resource;
    Class<?> contentType;

    public SpecialNodeType(Resource resource, Class<?> contentType) {
        this.resource = resource;
        this.contentType = contentType;
    }

    public static SpecialNodeType create(ReadGraph g, Resource r) throws DatabaseException {
        Class contentType;
        block12: {
            ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
            String contentTypeName = (String)g.getPossibleRelatedValue(r, vr.HasContentType);
            if ("Resource".equals(contentTypeName)) {
                contentType = Resource.class;
            } else if ("Statement".equals(contentTypeName)) {
                contentType = Statement.class;
            } else if ("Variable".equals(contentTypeName)) {
                contentType = Variable.class;
            } else {
                contentType = Object.class;
                if (contentTypeName != null) {
                    try {
                        String bundleId = (String)g.getPossibleRelatedValue(r, vr.HasBundle);
                        Bundle bundle = null;
                        if (bundleId != null && (bundle = Platform.getBundle((String)bundleId)) == null) {
                            LOGGER.warn("Referenced bundle '" + bundleId + "' not found in platform.");
                        }
                        if (bundle != null) {
                            contentType = bundle.loadClass(contentTypeName);
                            break block12;
                        }
                        contentType = Class.forName(contentTypeName);
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.error("Unknown content type {} - {}", (Object)contentTypeName, (Object)e.getMessage());
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("Unknown content type {}", (Object)contentTypeName, (Object)e);
                        }
                        break block12;
                    }
                }
                LOGGER.warn("Content type is NULL.");
            }
        }
        return new SpecialNodeType(r, contentType);
    }

    @Override
    public NodeContext createNodeContext(ReadGraph graph, Object content) throws DatabaseException {
        if (this.contentType.isInstance(content)) {
            return NodeContextBuilder.buildWithData((NodeContext.ConstantKey[])KEY_SEQUENCE, (Object[])new Object[]{content, this});
        }
        return null;
    }

    @Override
    public Class<?> getContentType() {
        return this.contentType;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpecialNodeType other = (SpecialNodeType)obj;
        return this.resource.equals(other.resource);
    }

    @Override
    public boolean inherits(ReadGraph graph, NodeType superType) {
        return this.equals(superType);
    }

    @Override
    public Collection<NodeType> getSuper(ReadGraph g) {
        return Collections.emptyList();
    }

    @Override
    public String toString(ReadGraph graph) throws DatabaseException {
        return "(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource) + ")";
    }

    @Override
    public WorkbenchSelectionElement getWorkbenchSelectionElement(NodeContext context) {
        return null;
    }
}

