/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.tests;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public class OrTest implements Test {
    Collection<Test> tests;

    public OrTest(Collection<Test> tests) {
        this.tests = tests;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType == Resource.class;
    }

    @Override
    public boolean test(ReadGraph graph, Object content)
            throws DatabaseException {
        if (tests.isEmpty())
            return true;
        for (Test test : tests)
            if (test.test(graph, content))
                return true;
        return false;
    }

}
