/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.common.viewpoints.LazyContainerViewpoint;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.browsing.ui.graph.impl.TypeIndex;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class TypeIndexViewpointFactory
implements ViewpointFactory {
    public Viewpoint create(final PrimitiveQueryUpdater provider, final NodeContext context, final BuiltinKeys.ViewpointKey key) {
        assert (provider != null);
        assert (context != null);
        final LazyContainerViewpoint result = new LazyContainerViewpoint();
        DataSource source = provider.getDataSource(ReadGraph.class);
        if (source == null) {
            return result;
        }
        final Resource inputResource = (Resource)context.getConstant(BuiltinKeys.INPUT);
        assert (inputResource != null);
        source.schedule((Consumer)new Consumer<ReadGraph>(){

            @Override
            public void accept(ReadGraph source) {
                try {
                    HashMap<Resource, ArrayList<Resource>> index = new HashMap<Resource, ArrayList<Resource>>();
                    Layer0 L0 = Layer0.getInstance((ReadGraph)source);
                    for (Resource child : source.getObjects(inputResource, L0.ConsistsOf)) {
                        for (Resource type : source.getObjects(child, L0.InstanceOf)) {
                            ArrayList<Resource> coll = (ArrayList<Resource>)index.get(type);
                            if (coll == null) {
                                coll = new ArrayList<Resource>();
                                index.put(type, coll);
                            }
                            coll.add(child);
                        }
                    }
                    NodeContext[] resultContexts = new NodeContext[index.size()];
                    int index2 = 0;
                    for (Map.Entry e : index.entrySet()) {
                        Resource type = (Resource)e.getKey();
                        String rep = (String)source.adapt(type, String.class);
                        resultContexts[index2++] = NodeContextBuilder.buildWithInput((Object)new TypeIndex(type, (Collection)e.getValue(), rep));
                    }
                    result.setChildren(provider, resultContexts);
                    result.setHasChildren(Boolean.valueOf(resultContexts.length > 0));
                    provider.scheduleReplace(context, (NodeContext.PrimitiveQueryKey)key, (Object)result);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
        });
        return result;
    }

    public String toString() {
        return "Structure by types";
    }
}

