/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ResourceManager;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorDataImpl;
import org.simantics.browsing.ui.common.EvaluatorImpl;
import org.simantics.browsing.ui.common.exception.InvalidBrowserIdException;
import org.simantics.browsing.ui.common.extension.CheckedStateContributorBindingExtensionManager;
import org.simantics.browsing.ui.common.extension.ComparableContextContributorBindingExtensionManager;
import org.simantics.browsing.ui.common.extension.EvaluatorBindingExtensionManager;
import org.simantics.browsing.ui.common.extension.EvaluatorFactory;
import org.simantics.browsing.ui.common.extension.ImageDecoratorContributorBindingExtensionManager;
import org.simantics.browsing.ui.common.extension.ImagerContributorBindingExtensionManager;
import org.simantics.browsing.ui.common.extension.LabelDecoratorContributorBindingExtensionManager;
import org.simantics.browsing.ui.common.extension.LabelerContributorBindingExtensionManager;
import org.simantics.browsing.ui.common.extension.ViewpointContributionContributorBindingExtensionManager;
import org.simantics.browsing.ui.content.CheckedStateFactory;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.ContributorBinding;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.content.ImageDecoratorFactory;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.browsing.ui.graph.impl.ContributionViewpointFactory;
import org.simantics.browsing.ui.graph.impl.EvaluatorCheckedState;
import org.simantics.browsing.ui.graph.impl.EvaluatorImageDecorator;
import org.simantics.browsing.ui.graph.impl.EvaluatorImager;
import org.simantics.browsing.ui.graph.impl.EvaluatorLabelDecorator;
import org.simantics.browsing.ui.graph.impl.EvaluatorLabeler;
import org.simantics.browsing.ui.graph.impl.EvaluatorViewpoint;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.request.Read;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluators {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evaluators.class);
    public static final boolean DEBUG = false;

    public static void create(EvaluatorData data, ResourceManager resourceManager, Map<String, Collection<ContributorBinding<ViewpointContributionFactory>>> viewpointContributions, Set<ContributorBinding<ComparableContextFactory>> comparableContextContributions, Set<ContributorBinding<LabelerFactory>> labelerContributions, Set<ContributorBinding<CheckedStateFactory>> checkStateContributions, Set<ContributorBinding<LabelDecoratorFactory>> labelDecoratorContributions, Set<ContributorBinding<ImagerFactory>> imagerContributions, Set<ContributorBinding<ImageDecoratorFactory>> imageDecoratorContributions) {
        EvaluatorData.EvaluatorTree branch;
        EvaluatorData.Evaluator evaluator;
        Class clazz;
        Tester test;
        ContributionViewpointFactory factory;
        HashMap<Class, EvaluatorData.Evaluator> evaluators = new HashMap<Class, EvaluatorData.Evaluator>();
        HashMap<String, ContributionViewpointFactory> viewpointFactories = new HashMap<String, ContributionViewpointFactory>();
        for (Map.Entry<String, Collection<ContributorBinding<ViewpointContributionFactory>>> entry : viewpointContributions.entrySet()) {
            ArrayList<ViewpointContributionFactory> factories = new ArrayList<ViewpointContributionFactory>();
            for (ContributorBinding<ViewpointContributionFactory> binding : entry.getValue()) {
                factories.add((ViewpointContributionFactory)binding.getContributor().getFactory());
            }
            viewpointFactories.put(entry.getKey(), new ContributionViewpointFactory(entry.getKey(), factories));
        }
        for (Map.Entry<String, Collection<ContributorBinding<ViewpointContributionFactory>>> entry : viewpointContributions.entrySet()) {
            factory = (ContributionViewpointFactory)viewpointFactories.get(entry.getKey());
            for (ContributorBinding<ViewpointContributionFactory> binding : entry.getValue()) {
                Tester test2 = binding.getContributor().getNodeContextTester();
                Class clazz2 = binding.getContributor().getInputClass();
                EvaluatorData.Evaluator evaluator2 = (EvaluatorData.Evaluator)evaluators.get(clazz2);
                if (evaluator2 == null) {
                    evaluator2 = data.newEvaluator();
                    evaluators.put(clazz2, evaluator2);
                }
                if (test2 == null) {
                    evaluator2.addViewpoint((ViewpointFactory)factory, binding.getPreference());
                    continue;
                }
                EvaluatorData.EvaluatorTree branch2 = ((EvaluatorImpl)evaluator2).getViewpointTree().addBranch(test2);
                branch2.addFactory((Object)factory, binding.getPreference());
            }
        }
        for (ContributorBinding contributorBinding : comparableContextContributions) {
            factory = (ComparableContextFactory)contributorBinding.getContributor().getFactory();
            test = contributorBinding.getContributor().getNodeContextTester();
            clazz = contributorBinding.getContributor().getInputClass();
            evaluator = (EvaluatorData.Evaluator)evaluators.get(clazz);
            if (evaluator == null) {
                evaluator = data.newEvaluator();
                evaluators.put(clazz, evaluator);
            }
            if (test == null) {
                evaluator.addComparableContext((ComparableContextFactory)factory, contributorBinding.getPreference());
                continue;
            }
            branch = ((EvaluatorImpl)evaluator).getComparableContextTree().addBranch(test);
            branch.addFactory((Object)factory, contributorBinding.getPreference());
        }
        for (ContributorBinding contributorBinding : labelerContributions) {
            factory = (LabelerFactory)contributorBinding.getContributor().getFactory();
            test = contributorBinding.getContributor().getNodeContextTester();
            clazz = contributorBinding.getContributor().getInputClass();
            evaluator = (EvaluatorData.Evaluator)evaluators.get(clazz);
            if (evaluator == null) {
                evaluator = data.newEvaluator();
                evaluators.put(clazz, evaluator);
            }
            if (test == null) {
                evaluator.addLabeler((LabelerFactory)factory, contributorBinding.getPreference());
                continue;
            }
            branch = ((EvaluatorImpl)evaluator).getLabelerTree().addBranch(test);
            branch.addFactory((Object)factory, contributorBinding.getPreference());
        }
        for (ContributorBinding contributorBinding : checkStateContributions) {
            factory = (CheckedStateFactory)contributorBinding.getContributor().getFactory();
            test = contributorBinding.getContributor().getNodeContextTester();
            clazz = contributorBinding.getContributor().getInputClass();
            evaluator = (EvaluatorData.Evaluator)evaluators.get(clazz);
            if (evaluator == null) {
                evaluator = data.newEvaluator();
                evaluators.put(clazz, evaluator);
            }
            if (test == null) {
                evaluator.addCheckState((CheckedStateFactory)factory, contributorBinding.getPreference());
                continue;
            }
            branch = ((EvaluatorImpl)evaluator).getCheckStateTree().addBranch(test);
            branch.addFactory((Object)factory, contributorBinding.getPreference());
        }
        for (ContributorBinding contributorBinding : labelDecoratorContributions) {
            factory = (LabelDecoratorFactory)contributorBinding.getContributor().getFactory();
            test = contributorBinding.getContributor().getNodeContextTester();
            clazz = contributorBinding.getContributor().getInputClass();
            evaluator = (EvaluatorData.Evaluator)evaluators.get(clazz);
            if (evaluator == null) {
                evaluator = data.newEvaluator();
                evaluators.put(clazz, evaluator);
            }
            if (test == null) {
                evaluator.addLabelDecorator((LabelDecoratorFactory)factory, contributorBinding.getPreference());
                continue;
            }
            branch = ((EvaluatorImpl)evaluator).getLabelDecoratorTree().addBranch(test);
            branch.addFactory((Object)factory, contributorBinding.getPreference());
        }
        for (ContributorBinding contributorBinding : imagerContributions) {
            factory = (ImagerFactory)contributorBinding.getContributor().getFactory();
            test = contributorBinding.getContributor().getNodeContextTester();
            clazz = contributorBinding.getContributor().getInputClass();
            evaluator = (EvaluatorData.Evaluator)evaluators.get(clazz);
            if (evaluator == null) {
                evaluator = data.newEvaluator();
                evaluators.put(clazz, evaluator);
            }
            if (test == null) {
                evaluator.addImager((ImagerFactory)factory, contributorBinding.getPreference());
                continue;
            }
            branch = ((EvaluatorImpl)evaluator).getImagerTree().addBranch(test);
            branch.addFactory((Object)factory, contributorBinding.getPreference());
        }
        for (ContributorBinding contributorBinding : imageDecoratorContributions) {
            factory = (ImageDecoratorFactory)contributorBinding.getContributor().getFactory();
            test = contributorBinding.getContributor().getNodeContextTester();
            clazz = contributorBinding.getContributor().getInputClass();
            evaluator = (EvaluatorData.Evaluator)evaluators.get(clazz);
            if (evaluator == null) {
                evaluator = data.newEvaluator();
                evaluators.put(clazz, evaluator);
            }
            if (test == null) {
                evaluator.addImageDecorator((ImageDecoratorFactory)factory, contributorBinding.getPreference());
                continue;
            }
            branch = ((EvaluatorImpl)evaluator).getImageDecoratorTree().addBranch(test);
            branch.addFactory((Object)factory, contributorBinding.getPreference());
        }
        for (Map.Entry<String, Collection<Object>> entry : evaluators.entrySet()) {
            data.addEvaluator((Class)((Object)entry.getKey()), (EvaluatorData.Evaluator)entry.getValue());
        }
    }

    public static Set<String> loadModelled(RequestProcessor processor, final Set<String> browseContexts, ResourceManager resourceManager, final EvaluatorDataImpl data, final boolean useNodeBrowseContexts, final boolean useNodeActionContexts) {
        final HashSet<String> allBrowseContexts = new HashSet<String>(browseContexts);
        final EvaluatorImpl eval = new EvaluatorImpl();
        data.addEvaluator(Object.class, (EvaluatorData.Evaluator)eval);
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    ArrayList<Resource> browseContextResources = new ArrayList<Resource>(browseContexts.size());
                    for (String browseContext : browseContexts) {
                        try {
                            browseContextResources.add(graph.getResource(browseContext));
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("Unexpected error occurred while finding browse context " + browseContext + ".", (Throwable)e);
                        }
                    }
                    try {
                        String browseContext;
                        browseContext = BrowseContext.create((ReadGraph)graph, browseContextResources);
                        data.setBrowseContext((Object)browseContext);
                        for (Resource context : BrowseContext.findSubcontexts((ReadGraph)graph, browseContextResources)) {
                            String uri = graph.getPossibleURI(context);
                            if (uri == null) continue;
                            allBrowseContexts.add(uri);
                        }
                        eval.addLabeler(new LabelerFactory((BrowseContext)browseContext, useNodeBrowseContexts){
                            private final /* synthetic */ BrowseContext val$browseContext;
                            private final /* synthetic */ boolean val$useNodeBrowseContexts;
                            {
                                this.val$browseContext = browseContext;
                                this.val$useNodeBrowseContexts = bl;
                            }

                            public Labeler create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.LabelerKey key) {
                                return new EvaluatorLabeler(updater, context, key, this.val$browseContext, this.val$useNodeBrowseContexts);
                            }
                        }, 0.0);
                        eval.addImager(new ImagerFactory((BrowseContext)browseContext, useNodeBrowseContexts){
                            private final /* synthetic */ BrowseContext val$browseContext;
                            private final /* synthetic */ boolean val$useNodeBrowseContexts;
                            {
                                this.val$browseContext = browseContext;
                                this.val$useNodeBrowseContexts = bl;
                            }

                            public Imager create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ImagerKey key) {
                                return new EvaluatorImager(updater, context, key, this.val$browseContext, this.val$useNodeBrowseContexts);
                            }
                        }, 0.0);
                        eval.addCheckState(new CheckedStateFactory((BrowseContext)browseContext, useNodeBrowseContexts){
                            private final /* synthetic */ BrowseContext val$browseContext;
                            private final /* synthetic */ boolean val$useNodeBrowseContexts;
                            {
                                this.val$browseContext = browseContext;
                                this.val$useNodeBrowseContexts = bl;
                            }

                            public CheckedState create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.CheckedStateKey key) {
                                return new EvaluatorCheckedState(updater, context, key, this.val$browseContext, this.val$useNodeBrowseContexts).getState();
                            }
                        }, 0.0);
                        eval.addLabelDecorator(new LabelDecoratorFactory((BrowseContext)browseContext, useNodeBrowseContexts){
                            private final /* synthetic */ BrowseContext val$browseContext;
                            private final /* synthetic */ boolean val$useNodeBrowseContexts;
                            {
                                this.val$browseContext = browseContext;
                                this.val$useNodeBrowseContexts = bl;
                            }

                            public LabelDecorator create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.LabelDecoratorKey key) {
                                return new EvaluatorLabelDecorator(updater, context, key, this.val$browseContext, this.val$useNodeBrowseContexts);
                            }
                        }, 0.0);
                        eval.addImageDecorator(new ImageDecoratorFactory((BrowseContext)browseContext, useNodeBrowseContexts){
                            private final /* synthetic */ BrowseContext val$browseContext;
                            private final /* synthetic */ boolean val$useNodeBrowseContexts;
                            {
                                this.val$browseContext = browseContext;
                                this.val$useNodeBrowseContexts = bl;
                            }

                            public ImageDecorator create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ImageDecoratorKey key) {
                                return new EvaluatorImageDecorator(updater, context, key, this.val$browseContext, this.val$useNodeBrowseContexts);
                            }
                        }, 0.0);
                        eval.addViewpoint(new ViewpointFactory((BrowseContext)browseContext, useNodeBrowseContexts, useNodeActionContexts){
                            private final /* synthetic */ BrowseContext val$browseContext;
                            private final /* synthetic */ boolean val$useNodeBrowseContexts;
                            private final /* synthetic */ boolean val$useNodeActionContexts;
                            {
                                this.val$browseContext = browseContext;
                                this.val$useNodeBrowseContexts = bl;
                                this.val$useNodeActionContexts = bl2;
                            }

                            public Viewpoint create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointKey key) {
                                return new EvaluatorViewpoint(updater, context, key, this.val$browseContext, this.val$useNodeBrowseContexts, this.val$useNodeActionContexts);
                            }
                        }, 0.0);
                    }
                    catch (InvalidContribution e) {
                        e.printStackTrace();
                        return;
                    }
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return allBrowseContexts;
    }

    public static void loadExtensions(RequestProcessor processor, Set<String> browseContexts, ResourceManager resourceManager, Map<String, Collection<ContributorBinding<ViewpointContributionFactory>>> viewpointContributions, Set<ContributorBinding<ComparableContextFactory>> comparableContextContributions, Set<ContributorBinding<LabelerFactory>> labelerContributions, Set<ContributorBinding<CheckedStateFactory>> checkStateContributions, Set<ContributorBinding<LabelDecoratorFactory>> labelDecoratorContributions, Set<ContributorBinding<ImagerFactory>> imagerContributions, Set<ContributorBinding<ImageDecoratorFactory>> imageDecoratorContributions) {
        for (ContributorBinding binding : ViewpointContributionContributorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            String viewpointId = ((ViewpointContributionFactory)binding.getContributor().getFactory()).getViewpointId();
            Collection<ContributorBinding<ViewpointContributionFactory>> viewpoints = viewpointContributions.get(viewpointId);
            if (viewpoints == null) {
                viewpoints = new ArrayList<ContributorBinding<ViewpointContributionFactory>>();
                viewpointContributions.put(viewpointId, viewpoints);
            }
            viewpoints.add((ContributorBinding<ViewpointContributionFactory>)binding);
        }
        for (ContributorBinding binding : ComparableContextContributorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            comparableContextContributions.add((ContributorBinding<ComparableContextFactory>)binding);
        }
        for (ContributorBinding binding : LabelerContributorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            labelerContributions.add((ContributorBinding<LabelerFactory>)binding);
        }
        for (ContributorBinding binding : CheckedStateContributorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            checkStateContributions.add((ContributorBinding<CheckedStateFactory>)binding);
        }
        for (ContributorBinding binding : LabelDecoratorContributorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            labelDecoratorContributions.add((ContributorBinding<LabelDecoratorFactory>)binding);
        }
        for (ContributorBinding binding : ImagerContributorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            imagerContributions.add((ContributorBinding<ImagerFactory>)binding);
        }
        for (ContributorBinding binding : ImageDecoratorContributorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            imageDecoratorContributions.add((ContributorBinding<ImageDecoratorFactory>)binding);
        }
    }

    public static EvaluatorData load(RequestProcessor processor, Set<String> browseContexts, ResourceManager resourceManager) throws InvalidBrowserIdException {
        return Evaluators.load(processor, browseContexts, resourceManager, false, false);
    }

    public static EvaluatorData load(RequestProcessor processor, Set<String> browseContexts, ResourceManager resourceManager, boolean useNodeBrowseContexts, boolean useNodeActionContexts) throws InvalidBrowserIdException {
        HashMap<String, Collection<ContributorBinding<ViewpointContributionFactory>>> viewpointContributions = new HashMap<String, Collection<ContributorBinding<ViewpointContributionFactory>>>();
        HashSet<ContributorBinding<ComparableContextFactory>> comparableContextContributions = new HashSet<ContributorBinding<ComparableContextFactory>>();
        HashSet<ContributorBinding<LabelerFactory>> labelerContributions = new HashSet<ContributorBinding<LabelerFactory>>();
        HashSet<ContributorBinding<CheckedStateFactory>> checkStateContributions = new HashSet<ContributorBinding<CheckedStateFactory>>();
        HashSet<ContributorBinding<LabelDecoratorFactory>> labelDecoratorContributions = new HashSet<ContributorBinding<LabelDecoratorFactory>>();
        HashSet<ContributorBinding<ImagerFactory>> imagerContributions = new HashSet<ContributorBinding<ImagerFactory>>();
        HashSet<ContributorBinding<ImageDecoratorFactory>> imageDecoratorContributions = new HashSet<ContributorBinding<ImageDecoratorFactory>>();
        EvaluatorDataImpl data = new EvaluatorDataImpl();
        Set<String> allBrowseContexts = Evaluators.loadModelled(processor, browseContexts, resourceManager, data, useNodeBrowseContexts, useNodeActionContexts);
        Evaluators.loadExtensions(processor, allBrowseContexts, resourceManager, viewpointContributions, comparableContextContributions, labelerContributions, checkStateContributions, labelDecoratorContributions, imagerContributions, imageDecoratorContributions);
        Evaluators.create((EvaluatorData)data, resourceManager, viewpointContributions, comparableContextContributions, labelerContributions, checkStateContributions, labelDecoratorContributions, imagerContributions, imageDecoratorContributions);
        for (EvaluatorFactory factory : EvaluatorBindingExtensionManager.getInstance().getBoundFactories(allBrowseContexts)) {
            data.addEvaluator(factory.getClazz(), factory.create(allBrowseContexts));
        }
        return data;
    }
}

