/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.content.ViewpointContribution;

public abstract class ContributionStub
implements ViewpointContribution {
    protected Collection<NodeContext> children = ViewpointContribution.PENDING_CONTRIBUTION;

    public void setChildren(PrimitiveQueryUpdater updater, Collection<NodeContext> children) {
        if (children == null) {
            throw new NullPointerException("null children produced by " + this.getClass().getName());
        }
        for (NodeContext c : children) {
            updater.incRef(c);
        }
        for (NodeContext c : this.children) {
            updater.decRef(c);
        }
        this.children = children;
    }

    public NodeContext[] toContextsWithInput(Object ... children) {
        return NodeContextUtil.toContextsWithInput((Object[])children);
    }

    public Collection<NodeContext> toContextsWithInput(Collection<?> children) {
        return NodeContextUtil.toContextCollectionWithInput((Object[])new Object[]{children});
    }

    public NodeContext[] toContexts(Collection<?> children, NodeContextUtil.NodeContextFactory factory) {
        return NodeContextUtil.toContexts(children, (NodeContextUtil.NodeContextFactory)factory);
    }

    protected <T> T getInput(NodeContext context) {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o == null) {
            throw new NullPointerException("null input");
        }
        return (T)o;
    }

    protected <T> T tryGetInput(NodeContext context, Class<T> clazz) {
        Object o = context.getConstant(BuiltinKeys.INPUT);
        if (o != null && clazz.isInstance(o)) {
            return (T)o;
        }
        return null;
    }
}

