/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.labeler;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.BuiltinKeys.LabelDecoratorKey;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;
import org.simantics.browsing.ui.graph.impl.contribution.LabelDecoratorContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ReflectionUtils;

abstract public class LabelDecoratorContributorImpl<T> implements Contributor<LabelDecoratorFactory> {

    abstract public LabelDecorator getDecorator(ReadGraph graph, T input) throws DatabaseException;

    final private Class<?> clazz;

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public LabelDecoratorContributorImpl() {
        clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public LabelDecoratorContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public LabelDecoratorFactory getFactory() {

        return new LabelDecoratorFactory() {

            @Override
            public LabelDecorator create(final PrimitiveQueryUpdater updater, NodeContext context, LabelDecoratorKey key) {

                return new LabelDecoratorContributionImpl(updater, context, key) {

                    @SuppressWarnings("unchecked")
                    @Override
                    public LabelDecorator getDecorator(ReadGraph graph, NodeContext context) throws DatabaseException {

                        T input = (T)context.getConstant(BuiltinKeys.INPUT);

                        return LabelDecoratorContributorImpl.this.getDecorator(graph, input);

                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
