/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.imager;

import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.ImagerKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.graph.impl.contribution.ImagerContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ReflectionUtils;

public abstract class ColumnImagerContributorImpl<T> implements Contributor<ImagerFactory> {

    public abstract Map<String, ImageDescriptor> getDescriptors(ReadGraph graph, T input) throws DatabaseException;

    final private Class<?> clazz;

    @Override
    public String toString() {
        return getClass().getName();
    }

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public ColumnImagerContributorImpl() {
        clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public ColumnImagerContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ImagerFactory getFactory() {

        return new ImagerFactory() {

            @Override
            public String toString() {
                return ColumnImagerContributorImpl.this.toString();
            }

            @SuppressWarnings("unchecked")
            @Override
            public Imager create(final PrimitiveQueryUpdater updater, NodeContext context, final ImagerKey key) {

                return new ImagerContributionImpl(updater, context, key) {

                    @Override
                    public Map<String, ImageDescriptor> getDescriptors(ReadGraph graph, NodeContext context) throws DatabaseException {

                        T input = (T)context.getConstant(BuiltinKeys.INPUT);

                        return ColumnImagerContributorImpl.this.getDescriptors(graph, input);

                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
