/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Collections;
import java.util.Map;

import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.GraphExplorer.ModificationContext;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringRepresentationLabelerFactory implements LabelerFactory {

    String column = ColumnKeys.SINGLE;

    //static int counter = 0;

    public StringRepresentationLabelerFactory() {
    }

    public StringRepresentationLabelerFactory(String column) {
        this.column = column;
    }

    @Override
    public Labeler create(PrimitiveQueryUpdater updater, final NodeContext context, LabelerKey key) {
        assert(updater != null);
        assert(context != null);

        return new LazyGraphLabeler(updater, context, key) {
            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
//              if((counter++ % 5000) == 0) System.out.println("L" + counter);
                final Resource r = (Resource) context.getConstant(BuiltinKeys.INPUT);
                String representation = LabelerUtil.safeStringRepresentation(graph, r);
                return Collections.singletonMap(column, representation);
            }
            @Override
            public Modifier getModifier(ModificationContext modificationContext, String key) {
                ISessionContext session = Simantics.getSessionContext();
                if (session == null)
                    return null;

                if (column.equals(key)) {
                    return new GraphStringModifier(context, session.getSession()) {
                        @Override
                        public void doModify(WriteGraph graph, String label) throws DatabaseException {
                            getModifier().modify(graph, label);
                        }
                        @Override
                        public String createModifierInput(String fromLabel) {
                            return fromLabel;
                        }
                    };
                }
                return null;
            }

            @Override
            public Logger getLogger() {
                return LoggerFactory.getLogger(StringRepresentationLabelerFactory.class);
            }
        };
    }

}
